/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Trust;

import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.EffectManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TrustCommand
implements CommandExecutor {
    private final Infuse plugin;
    private final EffectManager trustManager;

    public TrustCommand(Infuse plugin, EffectManager trustManager) {
        this.plugin = plugin;
        this.trustManager = trustManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getMessage("trust_consoleusage", "&cOnly players can use this command."));
            return true;
        }
        Player caster = (Player)sender;
        if (args.length != 1) {
            caster.sendMessage(this.getMessage("trust_incorrectusage", "&cUsage: /%label% <player>").replace("%label%", label));
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            caster.sendMessage(this.getMessage("trust_noplayer", "&cPlayer not found."));
            return true;
        }
        if (caster.getUniqueId().equals(target.getUniqueId())) {
            caster.sendMessage(this.getMessage("trust_self", "&cYou always trust yourself. Surely..."));
            return true;
        }
        if (label.equalsIgnoreCase("trust")) {
            this.trustManager.addTrust(caster, target);
            caster.sendMessage(this.getMessage("trust_added", "&aYou now trust %target%.").replace("%target%", target.getName()));
            return true;
        }
        if (label.equalsIgnoreCase("untrust")) {
            this.trustManager.removeTrust(caster, target);
            caster.sendMessage(this.getMessage("trust_removed", "&eYou no longer trust %target%.").replace("%target%", target.getName()));
            return true;
        }
        return false;
    }

    private String getMessage(String path, String defaultMessage) {
        FileConfiguration messages = this.plugin.getMessages();
        String message = messages.getString(path, defaultMessage);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

