/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Managers;

import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.EffectMapping;
import com.catadmirer.infuseSMP.Managers.EffectMaps;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Drop
implements Listener {
    private final Infuse plugin;

    public Drop(Infuse plugin) {
        this.plugin = plugin;
    }

    private boolean isMace(ItemStack item) {
        return item != null && item.getType() == Material.POTION && item.getItemMeta().hasCustomModelData();
    }

    @EventHandler
    public void onPickup(PlayerPickupItemEvent event) {
        ItemStack item = event.getItem().getItemStack();
        if (this.isMace(item)) {
            this.playDustEffect(event.getPlayer(), true, EffectMapping.fromItem(item), event.getItem().getLocation());
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        final Item droppedItem = event.getItemDrop();
        ItemStack itemStack = droppedItem.getItemStack();
        if (this.isMace(itemStack)) {
            this.playDustEffectDrop(event.getPlayer(), false, EffectMapping.fromItem(itemStack), droppedItem.getLocation());
            new BukkitRunnable(this){

                public void run() {
                    droppedItem.setGlowing(true);
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }

    public String stripAllColors(String input) {
        if (input == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\u00a7#[0-9a-fA-F]{6})|(\u00a7x(\u00a7[0-9a-fA-F]){6})|(\u00a7[0-9a-fk-orA-FK-OR])|(\ufffdx(\ufffd[0-9a-fA-F]){6})|\ufffd");
        return pattern.matcher(input).replaceAll("");
    }

    private void playDustEffect(Player player, final boolean bottomToTop, EffectMapping itemName, Location location) {
        final Location base = location.add(0.0, 0.1, 0.0);
        final World world = location.getWorld();
        Color color = null;
        String itemthingy = itemName.getHackName();
        String meowmeow = this.stripAllColors(itemthingy);
        meowmeow = ChatColor.stripColor((String)meowmeow);
        String itemNameChanged = this.plugin.getEffectReversed(meowmeow);
        Integer abilityId = EffectMaps.getEffectNumber(itemNameChanged);
        switch (abilityId) {
            case 0: 
            case 1: {
                color = Color.GREEN;
                break;
            }
            case 2: 
            case 3: {
                color = Color.fromRGB((int)190, (int)163, (int)202);
                break;
            }
            case 4: 
            case 5: {
                color = Color.fromRGB((int)252, (int)120, (int)3);
                break;
            }
            case 6: 
            case 7: {
                color = Color.fromRGB((int)0, (int)255, (int)255);
                break;
            }
            case 8: 
            case 9: {
                color = Color.fromRGB((int)185, (int)108, (int)0);
                break;
            }
            case 10: 
            case 11: {
                color = Color.fromRGB((int)252, (int)0, (int)70);
                break;
            }
            case 14: 
            case 15: {
                color = Color.fromRGB((int)0, (int)90, (int)252);
                break;
            }
            case 16: 
            case 17: {
                color = Color.fromRGB((int)255, (int)3, (int)239);
                break;
            }
            case 18: 
            case 19: {
                color = Color.fromRGB((int)209, (int)164, (int)75);
                break;
            }
            case 20: 
            case 21: {
                color = Color.fromRGB((int)139, (int)0, (int)0);
                break;
            }
            case 22: 
            case 23: {
                color = Color.fromRGB((int)252, (int)237, (int)0);
                break;
            }
            case 24: 
            case 26: {
                color = Color.PURPLE;
                break;
            }
            case 25: 
            case 27: {
                color = Color.fromRGB((int)69, (int)3, (int)62);
                break;
            }
            case 28: 
            case 29: {
                color = Color.fromRGB((int)255, (int)0, (int)0);
                break;
            }
        }
        final Particle.DustOptions dust = new Particle.DustOptions(color, 0.7f);
        int points = 16;
        double radius = 0.6;
        new BukkitRunnable(this){
            double y = 0.0;

            public void run() {
                if (this.y > 2.0) {
                    this.cancel();
                } else {
                    double ringY = bottomToTop ? this.y : 2.0 - this.y;
                    for (int i = 0; i < 16; ++i) {
                        double angle = Math.PI * 2 * (double)i / 16.0;
                        double x = Math.cos(angle) * 0.6;
                        double z = Math.sin(angle) * 0.6;
                        world.spawnParticle(Particle.DUST, base.clone().add(x, ringY, z), 0, 0.0, 0.0, 0.0, 1.0, (Object)dust);
                    }
                    this.y += 0.15;
                }
            }
        }.runTaskTimer((Plugin)Infuse.getInstance(), 0L, 1L);
        world.playSound(base, Sound.ENTITY_TURTLE_EGG_BREAK, 1.3f, 1.2f);
    }

    private void playDustEffectDrop(Player player, final boolean bottomToTop, EffectMapping itemName, Location location) {
        final Location base = location.add(0.0, -1.5, 0.0);
        final World world = location.getWorld();
        Color color = null;
        String itemthingy = itemName.getHackName();
        String meowmeow = this.stripAllColors(itemthingy);
        meowmeow = ChatColor.stripColor((String)meowmeow);
        String itemNameChanged = this.plugin.getEffectReversed(meowmeow);
        Integer abilityId = EffectMaps.getEffectNumber(itemNameChanged);
        switch (abilityId) {
            case 0: 
            case 1: {
                color = Color.GREEN;
                break;
            }
            case 2: 
            case 3: {
                color = Color.fromRGB((int)190, (int)163, (int)202);
                break;
            }
            case 4: 
            case 5: {
                color = Color.fromRGB((int)252, (int)120, (int)3);
                break;
            }
            case 6: 
            case 7: {
                color = Color.fromRGB((int)0, (int)255, (int)255);
                break;
            }
            case 8: 
            case 9: {
                color = Color.fromRGB((int)185, (int)108, (int)0);
                break;
            }
            case 10: 
            case 11: {
                color = Color.fromRGB((int)252, (int)0, (int)70);
                break;
            }
            case 14: 
            case 15: {
                color = Color.fromRGB((int)0, (int)90, (int)252);
                break;
            }
            case 16: 
            case 17: {
                color = Color.fromRGB((int)255, (int)3, (int)239);
                break;
            }
            case 18: 
            case 19: {
                color = Color.fromRGB((int)209, (int)164, (int)75);
                break;
            }
            case 20: 
            case 21: {
                color = Color.fromRGB((int)139, (int)0, (int)0);
                break;
            }
            case 22: 
            case 23: {
                color = Color.fromRGB((int)252, (int)237, (int)0);
                break;
            }
            case 24: 
            case 26: {
                color = Color.PURPLE;
                break;
            }
            case 25: 
            case 27: {
                color = Color.fromRGB((int)69, (int)3, (int)62);
                break;
            }
            case 28: 
            case 29: {
                color = Color.fromRGB((int)255, (int)0, (int)0);
                break;
            }
        }
        final Particle.DustOptions dust = new Particle.DustOptions(color, 0.7f);
        int points = 16;
        double radius = 0.6;
        new BukkitRunnable(this){
            double y = 0.0;

            public void run() {
                if (this.y > 2.0) {
                    this.cancel();
                } else {
                    double ringY = bottomToTop ? this.y : 2.0 - this.y;
                    for (int i = 0; i < 16; ++i) {
                        double angle = Math.PI * 2 * (double)i / 16.0;
                        double x = Math.cos(angle) * 0.6;
                        double z = Math.sin(angle) * 0.6;
                        world.spawnParticle(Particle.DUST, base.clone().add(x, ringY, z), 0, 0.0, 0.0, 0.0, 1.0, (Object)dust);
                    }
                    this.y += 0.15;
                }
            }
        }.runTaskTimer((Plugin)Infuse.getInstance(), 0L, 1L);
        world.playSound(base, Sound.ENTITY_TURTLE_EGG_BREAK, 1.3f, 1.2f);
    }
}

