/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Managers;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class CooldownManager {
    private static final Map<UUID, Map<String, Long>> cooldowns = new ConcurrentHashMap<UUID, Map<String, Long>>();
    private static final Map<UUID, Map<String, Long>> durations = new ConcurrentHashMap<UUID, Map<String, Long>>();
    public static final Map<String, String> displayNames = new ConcurrentHashMap<String, String>();

    public static void setDuration(UUID playerUUID, String key, long seconds) {
        durations.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).put(key, System.currentTimeMillis() + seconds * 1000L);
    }

    public static boolean isEffectActive(UUID playerUUID, String key) {
        return CooldownManager.getEffectTimeLeft(playerUUID, key) > 0L;
    }

    public static long getEffectTimeLeft(UUID playerUUID, String key) {
        Map<String, Long> playerDurations = durations.get(playerUUID);
        if (playerDurations != null && playerDurations.containsKey(key)) {
            long timeLeft = playerDurations.get(key) - System.currentTimeMillis();
            return timeLeft > 0L ? timeLeft : 0L;
        }
        return 0L;
    }

    public static void clearSpecificDuration(UUID playerUUID, String key) {
        Map<String, Long> playerDurations = durations.get(playerUUID);
        if (playerDurations != null) {
            playerDurations.remove(key);
        }
    }

    public static void cleanupExpiredDurations() {
        long currentTime = System.currentTimeMillis();
        for (UUID playerUUID : durations.keySet()) {
            Map<String, Long> playerDurations = durations.get(playerUUID);
            if (playerDurations == null) continue;
            playerDurations.entrySet().removeIf(entry -> (Long)entry.getValue() <= currentTime);
        }
    }

    public static boolean isOnCooldown(UUID playerUUID, String key) {
        return CooldownManager.getCooldownTimeLeft(playerUUID, key) > 0L;
    }

    public static void setCooldown(UUID playerUUID, String key, long seconds) {
        cooldowns.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).put(key, System.currentTimeMillis() + seconds * 1000L);
    }

    public static long getCooldownTimeLeft(UUID playerUUID, String key) {
        Map<String, Long> playerCooldowns = cooldowns.get(playerUUID);
        if (playerCooldowns != null && playerCooldowns.containsKey(key)) {
            long timeLeft = playerCooldowns.get(key) - System.currentTimeMillis();
            return timeLeft > 0L ? timeLeft : 0L;
        }
        return 0L;
    }

    public static void clearSpecificCooldown(UUID playerUUID, String key) {
        Map<String, Long> playerCooldowns = cooldowns.get(playerUUID);
        if (playerCooldowns != null) {
            playerCooldowns.remove(key);
        }
    }

    public static void cleanupAllExpiredCooldowns() {
        long currentTime = System.currentTimeMillis();
        for (UUID playerUUID : cooldowns.keySet()) {
            Map<String, Long> playerCooldowns = cooldowns.get(playerUUID);
            if (playerCooldowns == null) continue;
            playerCooldowns.entrySet().removeIf(entry -> (Long)entry.getValue() <= currentTime);
        }
    }

    public static void removeAllCooldowns(UUID playerUUID) {
        cooldowns.remove(playerUUID);
    }
}

