/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.ExtraEffects;

import com.catadmirer.infuseSMP.Effects.Emerald;
import com.catadmirer.infuseSMP.Effects.Ender;
import com.catadmirer.infuseSMP.Effects.Feather;
import com.catadmirer.infuseSMP.Effects.Fire;
import com.catadmirer.infuseSMP.Effects.Frost;
import com.catadmirer.infuseSMP.Effects.Haste;
import com.catadmirer.infuseSMP.Effects.Heart;
import com.catadmirer.infuseSMP.Effects.Invisibility;
import com.catadmirer.infuseSMP.Effects.Ocean;
import com.catadmirer.infuseSMP.Effects.Regen;
import com.catadmirer.infuseSMP.Effects.Speed;
import com.catadmirer.infuseSMP.Effects.Strength;
import com.catadmirer.infuseSMP.Effects.Thunder;
import com.catadmirer.infuseSMP.ExtraEffects.Apophis;
import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.CooldownManager;
import com.catadmirer.infuseSMP.Managers.EffectManager;
import com.catadmirer.infuseSMP.Particles.AlsoParticles;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateHealth;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.profile.PlayerTextures;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Thief
implements Listener,
PacketListener {
    private final Plugin plugin;
    private Map<UUID, UUID> shapeshiftedPlayers = new HashMap<UUID, UUID>();
    private Map<UUID, BossBar> shapeshiftedBossBars = new HashMap<UUID, BossBar>();
    private Map<UUID, Integer> shapeshiftTimeLeft = new HashMap<UUID, Integer>();
    private final EffectManager trustManager;
    private final Emerald emeraldAbility;
    private final Feather featherAbility;
    private final Fire fireAbility;
    private final Frost frostAbility;
    private final Haste hasteAbility;
    private final Heart heartAbility;
    private final Invisibility invisibilityAbility;
    private final Ocean oceanAbility;
    private final Regen regenAbility;
    private final Speed speedAbility;
    private final Strength strengthAbility;
    private final Thunder thunderAbility;
    private final Ender enderAbility;
    private final Apophis aphopis;
    private final Set<UUID> active = new HashSet<UUID>();
    private final Set<UUID> activeSparks = new HashSet<UUID>();
    private final Set<UUID> frozenAttackers = new HashSet<UUID>();
    private final Set<UUID> spark = new HashSet<UUID>();

    public Thief(EffectManager trustManager, Infuse plugin) {
        this.plugin = plugin;
        this.trustManager = trustManager;
        this.emeraldAbility = new Emerald((Plugin)plugin);
        this.featherAbility = new Feather((Plugin)plugin, trustManager);
        this.fireAbility = new Fire((Plugin)plugin);
        this.frostAbility = new Frost(trustManager, plugin);
        this.hasteAbility = new Haste((Plugin)plugin);
        this.heartAbility = new Heart(plugin);
        this.invisibilityAbility = new Invisibility((Plugin)plugin, trustManager);
        this.oceanAbility = new Ocean((Plugin)plugin, trustManager);
        this.regenAbility = new Regen(plugin);
        this.speedAbility = new Speed((Plugin)plugin);
        this.strengthAbility = new Strength(plugin);
        this.thunderAbility = new Thunder(plugin, trustManager);
        this.enderAbility = new Ender(trustManager, plugin);
        this.aphopis = new Apophis(plugin);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        new BukkitRunnable(){

            public void run() {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    boolean shouldBeHidden = Thief.this.hasImmortalHackEquipped2(p, "1") || Thief.this.hasImmortalHackEquipped2(p, "2");
                    for (Player otherPlayer : Bukkit.getOnlinePlayers()) {
                        if (shouldBeHidden) {
                            otherPlayer.unlistPlayer(p);
                            continue;
                        }
                        if (!otherPlayer.canSee(p)) continue;
                        otherPlayer.listPlayer(p);
                    }
                }
            }
        }.runTaskTimer((Plugin)plugin, 0L, 20L);
    }

    @EventHandler
    public void handleOffhand(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("ability.use")) {
            boolean isLegendary = this.hasImmortalHackEquipped2(player, "1");
            boolean isCommon = this.hasImmortalHackEquipped2(player, "2");
            UUID playerUUID = player.getUniqueId();
            if (!CooldownManager.isOnCooldown(playerUUID, "thief") && (player.isSneaking() && isLegendary || !player.isSneaking() && isCommon)) {
                event.setCancelled(true);
                this.activateSpark(player);
            }
        }
    }

    public void activateSpark(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (!CooldownManager.isOnCooldown(playerUUID, "thief")) {
            this.active.add(playerUUID);
            String gemName2 = Infuse.getInstance().getEffect("aug_thief");
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
            boolean isAugmentedEme = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2));
            long emeDefaultCooldown = ((Integer)Infuse.getInstance().getCanfig("thief.cooldown.default")).longValue();
            long emeAugmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("thief.cooldown.augmented")).longValue();
            long emeCooldown = isAugmentedEme ? emeAugmentedCooldown : emeDefaultCooldown;
            CooldownManager.setDuration(playerUUID, "thief", 0L);
            CooldownManager.setCooldown(playerUUID, "thief", emeCooldown);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player deadPlayer = event.getEntity();
        Player killer = event.getEntity().getKiller();
        if (killer == null) {
            return;
        }
        if (this.hasImmortalHackEquipped2(killer, "1") || this.hasImmortalHackEquipped2(killer, "2")) {
            this.shapeshiftedPlayers.put(killer.getUniqueId(), deadPlayer.getUniqueId());
            this.shapeshift(killer, deadPlayer);
            this.startShapeshiftTimer(killer);
        } else if (this.shapeshiftedPlayers.containsKey(deadPlayer.getUniqueId())) {
            this.revertShapeshift(deadPlayer);
        }
    }

    private void startShapeshiftTimer(final Player killer) {
        int shapeshiftTime = 3600;
        final BossBar bossBar = Bukkit.createBossBar((String)"Shapeshift", (BarColor)BarColor.PINK, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        bossBar.setProgress(1.0);
        bossBar.addPlayer(killer);
        this.shapeshiftedBossBars.put(killer.getUniqueId(), bossBar);
        this.shapeshiftTimeLeft.putIfAbsent(killer.getUniqueId(), shapeshiftTime);
        new BukkitRunnable(){

            public void run() {
                Integer timeLeft = Thief.this.shapeshiftTimeLeft.get(killer.getUniqueId());
                if (timeLeft != null && timeLeft > 0) {
                    double progress = (double)timeLeft.intValue() / 3600.0;
                    bossBar.setProgress(progress);
                    Thief.this.shapeshiftTimeLeft.put(killer.getUniqueId(), timeLeft - 1);
                } else {
                    Thief.this.revertShapeshift(killer);
                    bossBar.removePlayer(killer);
                    this.cancel();
                }
            }
        }.runTaskTimer(this.plugin, 0L, 20L);
    }

    private void shapeshift(Player killer, Player deadPlayer) {
        killer.setCustomName(deadPlayer.getName());
        killer.setDisplayName(deadPlayer.getName());
        killer.setCustomNameVisible(true);
        PlayerTextures skinTexture = deadPlayer.getPlayerProfile().getTextures();
        PlayerProfile profile = Bukkit.createProfile((UUID)killer.getUniqueId(), (String)killer.getName());
        profile.setTextures(skinTexture);
        killer.setPlayerProfile(profile);
    }

    private void revertShapeshift(Player player) {
        if (!this.shapeshiftedPlayers.containsKey(player.getUniqueId())) {
            return;
        }
        UUID originalUUID = this.shapeshiftedPlayers.get(player.getUniqueId());
        Player originalPlayer = Bukkit.getPlayer((UUID)originalUUID);
        if (originalPlayer != null) {
            player.setCustomName(originalPlayer.getName());
            player.setDisplayName(originalPlayer.getName());
            PlayerTextures skinTexture = originalPlayer.getPlayerProfile().getTextures();
            PlayerProfile profile = Bukkit.createProfile((UUID)originalUUID, (String)originalPlayer.getName());
            profile.setTextures(skinTexture);
            player.setPlayerProfile(profile);
        }
        this.shapeshiftedPlayers.remove(player.getUniqueId());
        this.shapeshiftedBossBars.remove(player.getUniqueId());
        this.shapeshiftTimeLeft.remove(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.shapeshiftedPlayers.containsKey(player.getUniqueId())) {
            this.revertShapeshift(player);
        }
    }

    public static ItemStack createTHF() {
        ItemStack gem = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)gem.getItemMeta();
        if (meta != null) {
            String gemName = Infuse.getInstance().getEffect("thief");
            meta.setDisplayName(gemName);
            List<String> lore = Infuse.getInstance().getEffectLore("thief");
            meta.setColor(Color.fromRGB((int)255, (int)0, (int)0));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(26));
            gem.setItemMeta((ItemMeta)meta);
        }
        return gem;
    }

    public static boolean ISTHF(ItemStack item) {
        String gemName = Infuse.getInstance().getEffect("thief");
        return item != null && item.getType() == Material.POTION && item.getItemMeta().getDisplayName().equals(gemName);
    }

    private boolean hasImmortalHackEquipped2(Player player, String tier) {
        String currentHack = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), tier);
        String gemName2 = Infuse.getInstance().getEffect("aug_thief");
        String gemName = Infuse.getInstance().getEffect("thief");
        return currentHack != null && (currentHack.equals(gemName2) || currentHack.equals(gemName));
    }

    public String removeAug(String key) {
        if (key.startsWith("aug_")) {
            return key.substring(4);
        }
        return key;
    }

    @EventHandler
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player victim = (Player)entity;
            if (!(event.getDamager() instanceof Player)) {
                return;
            }
            Entity damager = event.getDamager();
            Player player = (Player)damager;
            UUID playerUUID = player.getUniqueId();
            if ((this.hasImmortalHackEquipped2(player, "1") || this.hasImmortalHackEquipped2(player, "2")) && this.active.contains(playerUUID)) {
                String hack0 = Infuse.getInstance().getEffectManager().getEffect(victim.getUniqueId(), "1");
                String hack01 = Infuse.getInstance().getEffectManager().getEffect(victim.getUniqueId(), "2");
                String effect1 = Infuse.getInstance().getEffectReversed(hack0);
                String effect2 = Infuse.getInstance().getEffectReversed(hack01);
                effect1 = this.removeAug(effect1);
                effect2 = this.removeAug(effect2);
                Random rand = new Random();
                if (effect1 != null && effect2 != null) {
                    String selectedHack = rand.nextBoolean() ? effect1 : effect2;
                    this.activateEffect(player, selectedHack, (Entity)victim);
                    this.active.remove(playerUUID);
                } else if (effect1 != null) {
                    this.activateEffect(player, effect1, (Entity)victim);
                    this.active.remove(playerUUID);
                } else if (effect2 != null) {
                    this.activateEffect(player, effect2, (Entity)victim);
                    this.active.remove(playerUUID);
                }
            }
        }
    }

    private void activateEffect(Player player, String hack, Entity victim) {
        if (hack != null) {
            switch (hack) {
                case "strength": {
                    this.activateStrength(player);
                    player.sendMessage("\u00a7eYou stole " + victim.getName() + "'s \u00a74Strength Effect");
                    break;
                }
                case "speed": {
                    this.activateSpeed(player);
                    player.sendMessage("\u00a7eYou stole " + victim.getName() + "'s \u00a7bSpeed Effect");
                    break;
                }
                case "heart": {
                    this.activateHeart(player);
                    player.sendMessage("\u00a7eYou stole " + victim.getName() + "'s \u00a7cHeart Effect");
                    break;
                }
                case "emerald": {
                    this.activateEmerald(player);
                    player.sendMessage("\u00a7eYou stole " + victim.getName() + "'s \u00a7aEmerald Effect");
                    break;
                }
                case "fire": {
                    this.activateFire(player);
                    player.sendMessage("\u00a7eYou stole " + victim.getName() + "'s \u00a76Fire Effect");
                    break;
                }
                case "feather": {
                    this.activateFeather(player);
                    player.sendMessage("\u00a7eYou stole " + victim.getName() + "'s \u00a7fFeather Effect");
                    break;
                }
                case "haste": {
                    this.activateHaste(player);
                    player.sendMessage("\u00a7eYou stole " + victim.getName() + "'s \u00a76Haste Effect");
                    break;
                }
                case "ocean": {
                    this.activateOcean(player);
                    player.sendMessage("\u00a7eYou stole " + victim.getName() + "'s \u00a79Ocean Effect");
                    break;
                }
                case "invis": {
                    this.activateInvis(player);
                    player.sendMessage("\u00a7eYou stole " + victim.getName() + "'s \u00a7fInvisibility Effect");
                    break;
                }
                case "frost": {
                    this.activateFrost(player);
                    player.sendMessage("\u00a7eYou stole " + victim.getName() + "'s \u00a7bFrost Effect");
                    break;
                }
                case "regen": {
                    this.activateRegen(player);
                    player.sendMessage("\u00a7eYou stole " + victim.getName() + "'s \u00a7cRegeneration Effect");
                    break;
                }
                case "thunder": {
                    this.activateThunder(player);
                    player.sendMessage("\u00a7eYou stole " + victim.getName() + "'s \u00a7eThunder Effect");
                    break;
                }
                case "ender": {
                    this.activateEnder(player);
                    player.sendMessage("\u00a7eYou stole " + victim.getName() + "'s \u00a75Ender Effect");
                    break;
                }
                case "aug_ender": {
                    this.activateEnder(player);
                    player.sendMessage("\u00a7eYou stole " + victim.getName() + "'s \u00a75Ender Effect");
                    break;
                }
                case "apophis": {
                    this.activateApohpis(player);
                    player.sendMessage("\u00a7eYou stole " + victim.getName() + "'s \u00a75Apohpis Effect");
                    break;
                }
            }
        }
    }

    public void activateApohpis(final Player player) {
        UUID playerUUID = player.getUniqueId();
        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
        player.addPotionEffect(new PotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE, 600, 254));
        final AttributeInstance maxHealthAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        for (Entity entity : player.getNearbyEntities(5.0, 5.0, 5.0)) {
            if (!(entity instanceof LivingEntity) || entity == player) continue;
            entity.setFireTicks(100);
        }
        this.spawnSparkEffect(player);
        new BukkitRunnable(this){

            public void run() {
                player.getWorld().spawnParticle(Particle.EXPLOSION, player.getLocation(), 1);
            }
        }.runTaskLater(this.plugin, 20L);
        if (maxHealthAttribute != null) {
            maxHealthAttribute.setBaseValue(40.0);
        }
        String gemName2 = Infuse.getInstance().getEffect("aug_thief");
        player.setHealth(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
        boolean isAugmentedAph = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2));
        long aphDefaultCooldown = ((Integer)Infuse.getInstance().getCanfig("apophis.cooldown.default")).longValue();
        long aphAugmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("apophis.cooldown.augmented")).longValue();
        long aphCooldown = isAugmentedAph ? aphAugmentedCooldown : aphDefaultCooldown;
        long aphDefaultDuration = ((Integer)Infuse.getInstance().getCanfig("apophis.duration.default")).longValue();
        long aphAugmentedDuration = ((Integer)Infuse.getInstance().getCanfig("apophis.duration.augmented")).longValue();
        long aphDuration = isAugmentedAph ? aphAugmentedDuration : aphDefaultDuration;
        CooldownManager.setDuration(playerUUID, "thief", aphDuration);
        CooldownManager.setCooldown(playerUUID, "thief", aphCooldown * 2L);
        new BukkitRunnable(this){

            public void run() {
                if (maxHealthAttribute != null) {
                    maxHealthAttribute.setBaseValue(20.0);
                }
            }
        }.runTaskLater((Plugin)Infuse.getInstance(), 1200L);
    }

    private void spawnSparkEffect(final Player caster) {
        new BukkitRunnable(){
            int tick = 0;

            public void run() {
                if (this.tick >= 100) {
                    Thief.this.startDarkRedDustEffect(caster.getLocation(), caster);
                    this.cancel();
                } else {
                    Location center = caster.getLocation();
                    World world = center.getWorld();
                    if (this.tick > 0 && this.tick % 20 == 0) {
                        world.playSound(center, Sound.ENTITY_PLAYER_HURT_ON_FIRE, 1.0f, 1.0f);
                        for (int angle = 0; angle < 360; angle += 20) {
                            double rad = Math.toRadians(angle);
                            double offsetX = 5.0 * Math.cos(rad);
                            double offsetZ = 5.0 * Math.sin(rad);
                            Location particleLoc = center.clone().add(offsetX, 0.1, offsetZ);
                            world.spawnParticle(Particle.LAVA, particleLoc, 10, 0.05, 0.05, 0.05, 0.01);
                        }
                        for (Player target : world.getPlayers()) {
                            if (target.equals((Object)caster) || !(target.getLocation().distance(center) <= 5.0)) continue;
                            target.damage(8.0, (Entity)caster);
                        }
                    }
                    ++this.tick;
                }
            }
        }.runTaskTimer(this.plugin, 0L, 1L);
    }

    public void activateEnder(Player player) {
        Location checkLoc;
        UUID playerUUID = player.getUniqueId();
        String gemName2 = Infuse.getInstance().getEffect("aug_thief");
        boolean isAugmented = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).equalsIgnoreCase(ChatColor.stripColor((String)ChatColor.stripColor((String)gemName2))) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).equalsIgnoreCase(ChatColor.stripColor((String)ChatColor.stripColor((String)gemName2)));
        long endFirstDuration = ((Integer)Infuse.getInstance().getCanfig("ender.duration.augmented")).longValue();
        long endFirstCooldown = ((Integer)Infuse.getInstance().getCanfig("ender.cooldown.augmented")).longValue();
        long endSecondDuration = ((Integer)Infuse.getInstance().getCanfig("ender.duration.default")).longValue();
        long endSecondCooldown = ((Integer)Infuse.getInstance().getCanfig("ender.cooldown.default")).longValue();
        long cooldown = isAugmented ? endFirstCooldown : endSecondCooldown;
        long duration = isAugmented ? endFirstDuration : endSecondDuration;
        CooldownManager.setDuration(playerUUID, "thief", duration);
        CooldownManager.setCooldown(playerUUID, "thief", cooldown * 2L);
        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
        Location startLoc = player.getEyeLocation();
        Vector direction = startLoc.getDirection().normalize();
        int maxDistance = 15;
        Location targetLoc = null;
        for (int i = 1; i <= maxDistance && this.isSafeTeleportLocation(checkLoc = startLoc.clone().add(direction.clone().multiply(i))); ++i) {
            targetLoc = checkLoc;
        }
        if (targetLoc != null) {
            Location finalLoc = targetLoc.clone();
            finalLoc.setYaw(player.getLocation().getYaw());
            finalLoc.setPitch(player.getLocation().getPitch());
            player.teleport(finalLoc);
        }
    }

    private boolean isSafeTeleportLocation(Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            return false;
        }
        Location feet = loc.clone();
        Location head = loc.clone().add(0.0, 1.0, 0.0);
        return !feet.getBlock().getType().isSolid() && !head.getBlock().getType().isSolid();
    }

    public void activateThunder(final Player caster) {
        final UUID playerUUID = caster.getUniqueId();
        this.activeSparks.add(playerUUID);
        caster.getWorld().playSound(caster.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
        String gemName2 = Infuse.getInstance().getEffect("aug_thief");
        boolean isAugmented = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).equalsIgnoreCase(ChatColor.stripColor((String)ChatColor.stripColor((String)gemName2))) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).equalsIgnoreCase(ChatColor.stripColor((String)ChatColor.stripColor((String)gemName2)));
        long defaultCooldown = ((Integer)Infuse.getInstance().getCanfig("thunder.cooldown.default")).longValue();
        long augmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("thunder.cooldown.augmented")).longValue();
        long cooldown = isAugmented ? augmentedCooldown : defaultCooldown;
        long defaultDuration = ((Integer)Infuse.getInstance().getCanfig("thunder.duration.default")).longValue();
        long augmentedDuration = ((Integer)Infuse.getInstance().getCanfig("thunder.duration.augmented")).longValue();
        long duration = isAugmented ? augmentedDuration : defaultDuration;
        final int effectDuration = (int)(duration * 20L);
        CooldownManager.setDuration(playerUUID, "thunder", duration);
        CooldownManager.setCooldown(playerUUID, "thunder", cooldown);
        double radius = 10.0;
        final World world = caster.getWorld();
        new BukkitRunnable(){
            int ticksElapsed = 0;

            public void run() {
                if (this.ticksElapsed >= effectDuration) {
                    Thief.this.activeSparks.remove(playerUUID);
                    this.cancel();
                    return;
                }
                Location center = caster.getLocation();
                for (Entity entity : world.getNearbyEntities(center, 10.0, 10.0, 10.0)) {
                    Player p;
                    LivingEntity target;
                    if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity).equals((Object)caster) || target instanceof Player && Thief.this.isTeammate(p = (Player)target, caster)) continue;
                    target.getWorld().strikeLightningEffect(target.getLocation());
                    target.damage(4.0, (Entity)caster);
                    world.spawnParticle(Particle.DUST, target.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.0, (Object)new Particle.DustOptions(Color.YELLOW, 1.5f));
                }
                this.ticksElapsed += 20;
            }
        }.runTaskTimer(this.plugin, 0L, 20L);
    }

    public void activateRegen(Player player) {
        UUID playerUUID = player.getUniqueId();
        String gemName2 = Infuse.getInstance().getEffect("aug_thief");
        boolean isAugmented = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2));
        long defaultCooldown = ((Integer)Infuse.getInstance().getCanfig("regen.cooldown.default")).longValue();
        long augmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("regen.cooldown.augmented")).longValue();
        long cooldown = isAugmented ? augmentedCooldown : defaultCooldown;
        long defaultDuration = ((Integer)Infuse.getInstance().getCanfig("regen.duration.default")).longValue();
        long augmentedDuration = ((Integer)Infuse.getInstance().getCanfig("regen.duration.augmented")).longValue();
        long duration = isAugmented ? augmentedDuration : defaultDuration;
        CooldownManager.setCooldown(playerUUID, "thief", cooldown);
        CooldownManager.setDuration(playerUUID, "thief", duration * 2L);
        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
    }

    public void activateFrost(final Player caster) {
        UUID playerUUID = caster.getUniqueId();
        String gemName = Infuse.getInstance().getEffect("aug_thief");
        caster.getWorld().playSound(caster.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
        caster.addPotionEffect(new PotionEffect(PotionEffectType.UNLUCK, 300, 0));
        boolean isAugmentedFrost = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName));
        long frostDefaultCooldown = ((Integer)Infuse.getInstance().getCanfig("frost.cooldown.default")).longValue();
        long frostAugmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("frost.cooldown.augmented")).longValue();
        long frostCooldown = isAugmentedFrost ? frostAugmentedCooldown : frostDefaultCooldown;
        long frostDefaultDuration = ((Integer)Infuse.getInstance().getCanfig("frost.duration.default")).longValue();
        long frostAugmentedDuration = ((Integer)Infuse.getInstance().getCanfig("frost.duration.augmented")).longValue();
        long frostDuration = isAugmentedFrost ? frostAugmentedDuration : frostDefaultDuration;
        CooldownManager.setDuration(playerUUID, "thief", frostDuration);
        CooldownManager.setCooldown(playerUUID, "thief", frostCooldown * 2L);
        Location center = caster.getLocation();
        double radius = 5.0;
        World world = caster.getWorld();
        final HashSet<Player> affectedPlayers = new HashSet<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.equals((Object)caster) || this.isTeammate(player, caster) || !player.getWorld().equals((Object)world) || !(player.getLocation().distance(center) <= radius)) continue;
            affectedPlayers.add(player);
            AttributeInstance jumpAttribute = player.getAttribute(Attribute.GENERIC_JUMP_STRENGTH);
            if (jumpAttribute == null) continue;
            jumpAttribute.setBaseValue(0.1);
        }
        this.frozenAttackers.add(caster.getUniqueId());
        new BukkitRunnable(){

            public void run() {
                for (Player player : affectedPlayers) {
                    AttributeInstance jumpAttribute = player.getAttribute(Attribute.GENERIC_JUMP_STRENGTH);
                    if (jumpAttribute == null) continue;
                    jumpAttribute.setBaseValue(0.42);
                }
                Thief.this.frozenAttackers.remove(caster.getUniqueId());
            }
        }.runTaskLater(this.plugin, frostDuration * 20L);
    }

    public void activateStrength(Player player) {
        UUID playerUUID = player.getUniqueId();
        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
        String gemName2 = Infuse.getInstance().getEffect("aug_thief");
        boolean isAugmented = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).equalsIgnoreCase(ChatColor.stripColor((String)ChatColor.stripColor((String)gemName2))) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).equalsIgnoreCase(ChatColor.stripColor((String)ChatColor.stripColor((String)gemName2)));
        long defaultDuration = ((Integer)Infuse.getInstance().getCanfig("strength.duration.default")).longValue();
        long augmentedDuration = ((Integer)Infuse.getInstance().getCanfig("strength.duration.augmented")).longValue();
        long duration = isAugmented ? augmentedDuration : defaultDuration;
        long defaultCooldown = ((Integer)Infuse.getInstance().getCanfig("strength.cooldown.default")).longValue();
        long augmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("strength.cooldown.augmented")).longValue();
        long cooldown = isAugmented ? augmentedCooldown : defaultCooldown;
        CooldownManager.setDuration(playerUUID, "thief", duration);
        CooldownManager.setCooldown(playerUUID, "thief", cooldown * 2L);
    }

    public void activateSpeed(final Player player) {
        UUID playerUUID = player.getUniqueId();
        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
        final Vector direction = player.getEyeLocation().getDirection().normalize();
        double dashMultiplier = this.plugin.getConfig().getDouble("speed.dashMultiplier", 20.0);
        Vector dashVector = direction.clone().multiply(dashMultiplier);
        final Location startLocation = player.getLocation();
        final Location endLocation = startLocation.clone().add(dashVector);
        double playerVelocityMultiplier = this.plugin.getConfig().getDouble("speed.playerVelocityMultiplier", 2.0);
        player.setVelocity(direction.clone().multiply(playerVelocityMultiplier));
        player.getWorld().spawnParticle(Particle.CLOUD, startLocation, 50, 0.5, 0.5, 0.5, 0.1);
        new BukkitRunnable(this){

            public void run() {
                double distance = startLocation.distance(endLocation);
                Vector step = direction.clone().multiply(0.5);
                for (double d = 0.0; d <= distance; d += step.length()) {
                    Location currentLocation = startLocation.clone().add(step.clone().multiply(d));
                    player.getWorld().spawnParticle(Particle.CLOUD, currentLocation, 5, 0.1, 0.1, 0.1, 0.05);
                }
            }
        }.runTaskLater(this.plugin, 10L);
        long defaultDuration = ((Integer)Infuse.getInstance().getCanfig("speed.duration.default")).longValue();
        CooldownManager.setDuration(playerUUID, "speed", defaultDuration);
        String gemName2 = Infuse.getInstance().getEffect("aug_thief");
        boolean isAugmented = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).equalsIgnoreCase(ChatColor.stripColor((String)gemName2)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).equalsIgnoreCase(ChatColor.stripColor((String)gemName2));
        long defaultCooldown = ((Integer)Infuse.getInstance().getCanfig("speed.cooldown.default")).longValue();
        long augmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("speed.cooldown.augmented")).longValue();
        long cooldown = isAugmented ? augmentedCooldown : defaultCooldown;
        CooldownManager.setCooldown(playerUUID, "thief", cooldown * 2L);
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player player;
        Entity var3 = event.getDamager();
        if (var3 instanceof Player && CooldownManager.isEffectActive((player = (Player)var3).getUniqueId(), "thief") && !event.isCritical()) {
            double originalDamage = event.getDamage();
            double critDamage = originalDamage * 1.35;
            event.setDamage(critDamage);
            Entity hitEntity = event.getEntity();
            hitEntity.getWorld().playSound(hitEntity.getLocation(), Sound.ENTITY_PLAYER_ATTACK_CRIT, 1.0f, 1.0f);
            hitEntity.getWorld().spawnParticle(Particle.CRIT, hitEntity.getLocation().add(0.0, hitEntity.getHeight() / 2.0, 0.0), 10);
        }
    }

    public void activateHeart(Player player) {
        UUID playerUUID = player.getUniqueId();
        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
        final AttributeInstance maxHealthAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (maxHealthAttribute != null) {
            maxHealthAttribute.setBaseValue(40.0);
        }
        player.setHealth(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
        String gemName2 = Infuse.getInstance().getEffect("aug_thief");
        boolean isAugmentedHeart = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2));
        long defaultCooldown = ((Integer)Infuse.getInstance().getCanfig("health.cooldown.default")).longValue();
        long augmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("health.cooldown.augmented")).longValue();
        long cooldown = isAugmentedHeart ? augmentedCooldown : defaultCooldown;
        long defaultDuration = ((Integer)Infuse.getInstance().getCanfig("health.duration.default")).longValue();
        long augmentedDuration = ((Integer)Infuse.getInstance().getCanfig("health.duration.augmented")).longValue();
        long duration = isAugmentedHeart ? augmentedDuration : defaultDuration;
        CooldownManager.setDuration(playerUUID, "thief", duration);
        CooldownManager.setCooldown(playerUUID, "thief", cooldown * 2L);
        new BukkitRunnable(this){

            public void run() {
                if (maxHealthAttribute != null) {
                    maxHealthAttribute.setBaseValue(20.0);
                }
            }
        }.runTaskLater(this.plugin, duration * 20L);
    }

    public void activateEmerald(Player player) {
        UUID playerUUID = player.getUniqueId();
        String gemName2 = Infuse.getInstance().getEffect("aug_thief");
        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
        player.addPotionEffect(new PotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE, 600, 254));
        boolean isAugmentedEme = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2));
        long emeDefaultCooldown = ((Integer)Infuse.getInstance().getCanfig("emerald.cooldown.default")).longValue();
        long emeAugmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("emerald.cooldown.augmented")).longValue();
        long emeCooldown = isAugmentedEme ? emeAugmentedCooldown : emeDefaultCooldown;
        long emeDefaultDuration = ((Integer)Infuse.getInstance().getCanfig("emerald.duration.default")).longValue();
        long emeAugmentedDuration = ((Integer)Infuse.getInstance().getCanfig("emerald.duration.augmented")).longValue();
        long emeDuration = isAugmentedEme ? emeAugmentedDuration : emeDefaultDuration;
        CooldownManager.setDuration(playerUUID, "thief", emeDuration);
        CooldownManager.setCooldown(playerUUID, "thief", emeCooldown * 2L);
    }

    public void activateFire(final Player player) {
        UUID playerUUID = player.getUniqueId();
        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.0f);
        for (Entity entity : player.getNearbyEntities(5.0, 5.0, 5.0)) {
            if (!(entity instanceof LivingEntity) || entity == player) continue;
            entity.setFireTicks(100);
        }
        this.spawnSparkEffect(player);
        String gemName2 = Infuse.getInstance().getEffect("aug_thief");
        new BukkitRunnable(this){

            public void run() {
                player.getWorld().spawnParticle(Particle.EXPLOSION, player.getLocation(), 1);
            }
        }.runTaskLater(this.plugin, 20L);
        boolean isAugmentedFire = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2));
        long sparkDefaultCooldown = ((Integer)Infuse.getInstance().getCanfig("fire.cooldown.default")).longValue();
        long sparkAugmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("fire.cooldown.augmented")).longValue();
        long sparkCooldown = isAugmentedFire ? sparkAugmentedCooldown : sparkDefaultCooldown;
        long sparkDefaultDuration = ((Integer)Infuse.getInstance().getCanfig("fire.duration.default")).longValue();
        long sparkAugmentedDuration = ((Integer)Infuse.getInstance().getCanfig("fire.duration.augmented")).longValue();
        long sparkDuration = isAugmentedFire ? sparkAugmentedDuration : sparkDefaultDuration;
        CooldownManager.setDuration(playerUUID, "thief", sparkDuration);
        CooldownManager.setCooldown(playerUUID, "thief", sparkCooldown * 2L);
    }

    private void startDarkRedDustEffect(final Location startLoc, Player caster) {
        final World world = startLoc.getWorld();
        double explosionRadius = 5.0;
        for (Player target : world.getPlayers()) {
            if (target.equals((Object)caster) || !(target.getLocation().distance(startLoc) <= explosionRadius)) continue;
            target.setVelocity(new Vector(0.0, 2.0, 0.0));
        }
        world.playSound(startLoc, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
        new BukkitRunnable(this){
            int tick = 0;

            public void run() {
                if (this.tick >= 60) {
                    this.cancel();
                } else {
                    double baseRadius = 5.0;
                    double spreadFactor = (double)this.tick * 0.1;
                    double circleRadius = baseRadius + spreadFactor;
                    double particleHeightOffset = (double)this.tick * 3.0;
                    if (particleHeightOffset > 30.0) {
                        this.cancel();
                    } else {
                        for (int angle = 0; angle < 360; ++angle) {
                            double rad = Math.toRadians(angle);
                            double offsetX = circleRadius * Math.cos(rad);
                            double offsetZ = circleRadius * Math.sin(rad);
                            Location particleLoc = startLoc.clone().add(offsetX, particleHeightOffset, offsetZ);
                            world.spawnParticle(Particle.DUST_PILLAR, particleLoc, 3, 0.0, 0.0, 0.0, 0.0, (Object)Material.REDSTONE_BLOCK.createBlockData());
                        }
                        ++this.tick;
                    }
                }
            }
        }.runTaskTimer(this.plugin, 0L, 1L);
    }

    public void activateFeather(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (!CooldownManager.isOnCooldown(playerUUID, "aug_thief")) {
            String gemName = Infuse.getInstance().getEffect("aug_thief");
            player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
            AlsoParticles.spawnEffect(player, Color.fromRGB((int)190, (int)163, (int)202));
            Vector dashDirection = player.getEyeLocation().getDirection().normalize();
            Vector launchVector = dashDirection.multiply(0).setY(1);
            player.setVelocity(launchVector);
            player.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 20, 10));
            boolean isAugmentedFeather = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).equalsIgnoreCase(ChatColor.stripColor((String)gemName)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).equalsIgnoreCase(ChatColor.stripColor((String)gemName));
            long featherDefaultCooldown = ((Integer)Infuse.getInstance().getCanfig("feather.cooldown.default")).longValue();
            long featherAugmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("feather.cooldown.augmented")).longValue();
            long featherCooldown = isAugmentedFeather ? featherAugmentedCooldown : featherDefaultCooldown;
            long featherDefaultDuration = ((Integer)Infuse.getInstance().getCanfig("feather.duration.default")).longValue();
            long featherAugmentedDuration = ((Integer)Infuse.getInstance().getCanfig("feather.duration.augmented")).longValue();
            long featherDuration = isAugmentedFeather ? featherAugmentedDuration : featherDefaultDuration;
            CooldownManager.setDuration(playerUUID, "feather", featherDuration);
            CooldownManager.setCooldown(playerUUID, "feather", featherCooldown * 2L);
            Location anchor = player.getLocation();
            Bukkit.getRegionScheduler().runDelayed(this.plugin, anchor, task -> {
                if (player.isOnline()) {
                    CooldownManager.setDuration(playerUUID, "thiefmace", 5L);
                }
            }, 10L);
            this.spark.add(playerUUID);
        }
    }

    @EventHandler
    public void FeatherLand(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        double radius = 4.0;
        UUID playerUUID = player.getUniqueId();
        if (player.isOnGround() && CooldownManager.isEffectActive(playerUUID, "thiefmace")) {
            CooldownManager.setDuration(playerUUID, "thiefmace", 0L);
            Location loc = player.getLocation();
            World world = player.getWorld();
            Iterator var8 = player.getNearbyEntities(radius, radius, radius).iterator();
            while (true) {
                LivingEntity target;
                if (!var8.hasNext()) {
                    world.spawnParticle(Particle.CLOUD, loc, 50, 0.0, 0.0, 0.0, 2.0);
                    world.playSound(loc, Sound.ITEM_MACE_SMASH_GROUND_HEAVY, 1.5f, 1.0f);
                    Location anchor = player.getLocation();
                    Bukkit.getRegionScheduler().runDelayed((Plugin)Infuse.getInstance(), anchor, task -> {
                        if (player.isOnline()) {
                            Vector dashDirection = player.getEyeLocation().getDirection().normalize();
                            Vector launchVector = dashDirection.multiply(5);
                            player.setVelocity(launchVector);
                        }
                    }, 1L);
                    return;
                }
                Entity entity = (Entity)var8.next();
                if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity).equals((Object)player) || target instanceof Player && this.isTeammate(player, (Player)target)) continue;
                int damage = 5;
                target.damage((double)damage);
                Vector knockback = new Vector(0, 1, 0);
                target.setVelocity(target.getVelocity().add(knockback));
                Location anchor = target.getLocation();
                LivingEntity finalTarget = target;
                Bukkit.getRegionScheduler().run((Plugin)Infuse.getInstance(), anchor, task -> finalTarget.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 80, 0, false, false, false)));
            }
        }
    }

    private void applyNextAttackBonus(Player player) {
        for (Entity entity : player.getNearbyEntities(5.0, 5.0, 5.0)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            player.getWorld().playSound(player.getLocation(), Sound.ITEM_MACE_SMASH_GROUND_HEAVY, 1.0f, 1.0f);
            livingEntity.damage(10.0);
        }
    }

    @EventHandler
    public void onPlayerFallDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            UUID playerUUID;
            Player player = (Player)entity;
            if (event.getCause() == EntityDamageEvent.DamageCause.FALL && this.spark.contains(playerUUID = player.getUniqueId())) {
                this.applyNextAttackBonus(player);
                this.spark.remove(playerUUID);
            }
        }
    }

    public void activateHaste(Player player) {
        UUID playerUUID = player.getUniqueId();
        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
        String gemName = Infuse.getInstance().getEffect("aug_thief");
        boolean isAugmentedHaste = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName));
        long hasteDefaultCooldown = ((Integer)Infuse.getInstance().getCanfig("haste.cooldown.default")).longValue();
        long hasteAugmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("haste.cooldown.augmented")).longValue();
        long hasteCooldown = isAugmentedHaste ? hasteAugmentedCooldown : hasteDefaultCooldown;
        long hasteDefaultDuration = ((Integer)Infuse.getInstance().getCanfig("haste.duration.default")).longValue();
        long hasteAugmentedDuration = ((Integer)Infuse.getInstance().getCanfig("haste.duration.augmented")).longValue();
        long hasteDuration = isAugmentedHaste ? hasteAugmentedDuration : hasteDefaultDuration;
        player.addPotionEffect(new PotionEffect(PotionEffectType.HASTE, 300, 3));
        CooldownManager.setDuration(playerUUID, "thief", hasteDuration);
        CooldownManager.setCooldown(playerUUID, "thief", hasteCooldown * 2L);
    }

    public void activateOcean(final Player caster) {
        UUID playerUUID = caster.getUniqueId();
        caster.playSound(caster.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
        double radius = 5.0;
        final World world = caster.getWorld();
        String gemName2 = Infuse.getInstance().getEffect("aug_thief");
        boolean isAugmented = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2));
        long defaultCooldown = ((Integer)Infuse.getInstance().getCanfig("ocean.cooldown.default")).longValue();
        long augmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("ocean.cooldown.augmented")).longValue();
        long cooldown = isAugmented ? augmentedCooldown : defaultCooldown;
        long defaultDuration = ((Integer)Infuse.getInstance().getCanfig("ocean.duration.default")).longValue();
        long augmentedDuration = ((Integer)Infuse.getInstance().getCanfig("ocean.duration.augmented")).longValue();
        long duration = isAugmented ? augmentedDuration : defaultDuration;
        CooldownManager.setDuration(playerUUID, "thief", duration * 2L);
        CooldownManager.setCooldown(playerUUID, "thief", cooldown * 2L);
        final long durationTicks = duration * 20L;
        new BukkitRunnable(this){
            long ticksElapsed = 0L;

            public void run() {
                if (this.ticksElapsed >= durationTicks) {
                    this.cancel();
                    return;
                }
                for (int angle = 0; angle < 360; angle += 10) {
                    double rad = Math.toRadians(angle);
                    double x = caster.getLocation().getX() + 5.0 * Math.cos(rad);
                    double z = caster.getLocation().getZ() + 5.0 * Math.sin(rad);
                    Location particleLoc = new Location(world, x, caster.getLocation().getY(), z);
                    world.spawnParticle(Particle.FALLING_WATER, particleLoc, 1);
                }
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (p.equals((Object)caster) || !p.getWorld().equals((Object)world) || !(p.getLocation().distance(caster.getLocation()) <= 5.0)) continue;
                    Vector direction = caster.getLocation().toVector().subtract(p.getLocation().toVector()).normalize();
                    p.setVelocity(direction.multiply(0.5));
                    if (!p.getLocation().getBlock().isLiquid()) continue;
                    int newOxygen = Math.max(p.getRemainingAir() - 20, -20);
                    p.setRemainingAir(newOxygen);
                    if (newOxygen > 0) continue;
                    p.damage(2.0);
                }
                this.ticksElapsed += 10L;
            }
        }.runTaskTimer(this.plugin, 0L, 10L);
    }

    public void activateInvis(final Player caster) {
        UUID playerUUID = caster.getUniqueId();
        caster.playSound(caster.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
        String gemName2 = Infuse.getInstance().getEffect("aug_thief");
        boolean isAugmentedInvis = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2));
        long invisDefaultCooldown = ((Integer)Infuse.getInstance().getCanfig("invisibility.cooldown.default")).longValue();
        long invisAugmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("invisibility.cooldown.augmented")).longValue();
        long invisCooldown = isAugmentedInvis ? invisAugmentedCooldown : invisDefaultCooldown;
        long invisDefaultDuration = ((Integer)Infuse.getInstance().getCanfig("invisibility.duration.default")).longValue();
        long invisAugmentedDuration = ((Integer)Infuse.getInstance().getCanfig("invisibility.duration.augmented")).longValue();
        long invisDuration = isAugmentedInvis ? invisAugmentedDuration : invisDefaultDuration;
        double radius = 10.0;
        final long durationTicks = invisDuration;
        final World world = caster.getWorld();
        final HashSet<Player> vanishedPlayers = new HashSet<Player>();
        for (Player vanished : Bukkit.getOnlinePlayers()) {
            if (!vanished.getWorld().equals((Object)world) || !(vanished.getLocation().distance(caster.getLocation()) <= 10.0) || !this.isTeammate(caster, vanished)) continue;
            vanishedPlayers.add(vanished);
        }
        for (Player vanished : vanishedPlayers) {
            for (Player other : Bukkit.getOnlinePlayers()) {
                if (other.equals((Object)vanished) || this.isTeammate(other, vanished)) continue;
                other.hidePlayer(this.plugin, vanished);
            }
        }
        new BukkitRunnable(){
            long ticksElapsed = 0L;

            public void run() {
                if (this.ticksElapsed >= durationTicks) {
                    this.cancel();
                    for (Player vanished : vanishedPlayers) {
                        for (Player other : Bukkit.getOnlinePlayers()) {
                            other.showPlayer(Thief.this.plugin, vanished);
                        }
                    }
                } else {
                    Location center = caster.getLocation();
                    for (int angle = 0; angle < 360; angle += 2) {
                        double rad = Math.toRadians(angle);
                        double baseX = center.getX() + 10.0 * Math.cos(rad);
                        double baseZ = center.getZ() + 10.0 * Math.sin(rad);
                        Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)0, (int)0, (int)0), 15.0f);
                        for (int i = 0; i < 1; ++i) {
                            double offsetX = (Math.random() - 0.5) * 0.3;
                            double offsetZ = (Math.random() - 0.5) * 0.3;
                            Location particleLoc = new Location(world, baseX + offsetX, center.getY(), baseZ + offsetZ);
                            world.spawnParticle(Particle.DUST, particleLoc, 1, (Object)dustOptions);
                        }
                    }
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        if (!p.getWorld().equals((Object)world) || !(p.getLocation().distance(center) <= 10.0) || Thief.this.isTeammate(p, caster)) continue;
                        p.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0, false, false));
                        Thief.this.hideHealthForPlayer(p, 2);
                    }
                    this.ticksElapsed += 10L;
                }
            }
        }.runTaskTimer(this.plugin, 0L, 10L);
        CooldownManager.setDuration(playerUUID, "thief", invisDuration);
        CooldownManager.setCooldown(playerUUID, "thief", invisCooldown * 2L);
    }

    private boolean isTeammate(Player player, Player caster) {
        return this.trustManager.isTrusted(player, caster);
    }

    private void hideHealthForPlayer(final Player player, final int durationSeconds) {
        new BukkitRunnable(this){
            int elapsedTicks = 0;

            public void run() {
                WrapperPlayServerUpdateHealth packet = new WrapperPlayServerUpdateHealth(20.0f, 20, 5.0f);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)packet);
                this.elapsedTicks += 2;
                if (this.elapsedTicks >= durationSeconds * 20) {
                    this.cancel();
                }
            }
        }.runTaskTimer(this.plugin, 0L, 2L);
    }
}

