/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.ExtraEffects;

import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.CooldownManager;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Apophis
implements Listener {
    private Infuse plugin;

    public Apophis(Infuse plugin) {
        this.plugin = plugin;
        this.startHealthCheckTask();
        new BukkitRunnable(){

            public void run() {
                Iterator var1 = Bukkit.getOnlinePlayers().iterator();
                while (var1.hasNext()) {
                    Player onlinePlayer = (Player)var1.next();
                    if (!Apophis.this.hasImmortalHackEquipped2(onlinePlayer, "1") && !Apophis.this.hasImmortalHackEquipped2(onlinePlayer, "2")) continue;
                    ItemStack mainHand = onlinePlayer.getInventory().getItemInMainHand();
                    Apophis.this.applyPassiveEffects(onlinePlayer);
                    if (!Apophis.this.isSword(mainHand) || mainHand.getEnchantmentLevel(Enchantment.LOOTING) >= 5) continue;
                    mainHand.addUnsafeEnchantment(Enchantment.LOOTING, 5);
                }
                return;
            }
        }.runTaskTimer((Plugin)plugin, 0L, 20L);
    }

    private void applyPassiveEffects(Player player) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.LUCK, 40, 9, false, false));
        player.addPotionEffect(new PotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE, 40, 2, false, false));
        player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 40, 2, false, false));
    }

    private boolean isSword(ItemStack item) {
        if (item == null) {
            return false;
        }
        Material type = item.getType();
        return type == Material.WOODEN_SWORD || type == Material.STONE_SWORD || type == Material.IRON_SWORD || type == Material.GOLDEN_SWORD || type == Material.DIAMOND_SWORD || type == Material.NETHERITE_SWORD;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        new BukkitRunnable(this){

            public void run() {
                AttributeInstance maxHealthAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
                if (maxHealthAttribute != null) {
                    maxHealthAttribute.setBaseValue(20.0);
                }
            }
        }.runTaskLater((Plugin)Infuse.getInstance(), 15L);
    }

    private void startHealthCheckTask() {
        new BukkitRunnable(){

            public void run() {
                Iterator var1 = Bukkit.getOnlinePlayers().iterator();
                while (var1.hasNext()) {
                    Player player = (Player)var1.next();
                    AttributeInstance maxHealthAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
                    if (maxHealthAttribute == null) continue;
                    double currentMaxHealth = maxHealthAttribute.getBaseValue();
                    if (!Apophis.this.hasImmortalHackEquipped2(player, "1") && !Apophis.this.hasImmortalHackEquipped2(player, "2") || currentMaxHealth != 20.0) continue;
                    maxHealthAttribute.setBaseValue(30.0);
                }
                return;
            }
        }.runTaskTimer((Plugin)Infuse.getInstance(), 0L, 20L);
    }

    private boolean hasImmortalHackEquipped2(Player player, String tier) {
        String currentHack = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), tier);
        String gemName = Infuse.getInstance().getEffect("apophis");
        String gemName2 = Infuse.getInstance().getEffect("aug_apophis");
        return currentHack != null && (currentHack.equals(gemName) || currentHack.equals(gemName2));
    }

    public static boolean ISPAPH(ItemStack item) {
        String gemName = Infuse.getInstance().getEffect("apophis");
        return item != null && item.getType() == Material.POTION && item.getItemMeta().getDisplayName().equals(gemName);
    }

    public static ItemStack createAPH() {
        ItemStack gem = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)gem.getItemMeta();
        if (meta != null) {
            String gemName = Infuse.getInstance().getEffect("apophis");
            meta.setDisplayName(gemName);
            List<String> lore = Infuse.getInstance().getEffectLore("apophis");
            meta.setColor(Color.fromRGB((int)69, (int)3, (int)62));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(25));
            gem.setItemMeta((ItemMeta)meta);
        }
        return gem;
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        this.handleOffhand(event);
    }

    public void handleOffhand(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("ability.use")) {
            boolean isLegendary = this.hasImmortalHackEquipped2(player, "1");
            boolean isCommon = this.hasImmortalHackEquipped2(player, "2");
            UUID playerUUID = player.getUniqueId();
            if ((!CooldownManager.isOnCooldown(playerUUID, "apophis") || CooldownManager.isOnCooldown(playerUUID, "apophis")) && (player.isSneaking() && isLegendary || !player.isSneaking() && isCommon)) {
                event.setCancelled(true);
                this.activateSpark(player);
            }
        }
    }

    @EventHandler
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        UUID attackerUUID = attacker.getUniqueId();
        long sparkActive = CooldownManager.getEffectTimeLeft(attackerUUID, "apophis");
        Entity entity2 = event.getEntity();
        if (entity2 instanceof Player) {
            Player target = (Player)entity2;
            if (sparkActive > 0L) {
                target.sendTitle("\ue090", "", 0, 60, 0);
            }
        }
    }

    public void activateSpark(final Player player) {
        UUID playerUUID = player.getUniqueId();
        if (!CooldownManager.isOnCooldown(playerUUID, "apophis")) {
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
            player.addPotionEffect(new PotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE, 600, 254));
            final AttributeInstance maxHealthAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            for (Entity entity : player.getNearbyEntities(5.0, 5.0, 5.0)) {
                if (!(entity instanceof LivingEntity) || entity == player) continue;
                entity.setFireTicks(100);
            }
            this.spawnSparkEffect(player);
            new BukkitRunnable(this){

                public void run() {
                    player.getWorld().spawnParticle(Particle.EXPLOSION, player.getLocation(), 1);
                }
            }.runTaskLater((Plugin)this.plugin, 20L);
            if (maxHealthAttribute != null) {
                maxHealthAttribute.setBaseValue(40.0);
            }
            String gemName2 = Infuse.getInstance().getEffect("aug_apophis");
            player.setHealth(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
            boolean isAugmentedAph = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2));
            long aphDefaultCooldown = ((Integer)Infuse.getInstance().getCanfig("apophis.cooldown.default")).longValue();
            long aphAugmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("apophis.cooldown.augmented")).longValue();
            long aphCooldown = isAugmentedAph ? aphAugmentedCooldown : aphDefaultCooldown;
            long aphDefaultDuration = ((Integer)Infuse.getInstance().getCanfig("apophis.duration.default")).longValue();
            long aphAugmentedDuration = ((Integer)Infuse.getInstance().getCanfig("apophis.duration.augmented")).longValue();
            long aphDuration = isAugmentedAph ? aphAugmentedDuration : aphDefaultDuration;
            CooldownManager.setDuration(playerUUID, "apophis", aphDuration);
            CooldownManager.setCooldown(playerUUID, "apophis", aphCooldown);
            new BukkitRunnable(this){

                public void run() {
                    if (maxHealthAttribute != null) {
                        maxHealthAttribute.setBaseValue(20.0);
                    }
                }
            }.runTaskLater((Plugin)Infuse.getInstance(), 1200L);
        }
    }

    private void spawnSparkEffect(final Player caster) {
        new BukkitRunnable(){
            int tick = 0;

            public void run() {
                if (this.tick >= 100) {
                    Apophis.this.startDarkRedDustEffect(caster.getLocation(), caster);
                    this.cancel();
                } else {
                    Location center = caster.getLocation();
                    World world = center.getWorld();
                    if (this.tick > 0 && this.tick % 20 == 0) {
                        world.playSound(center, Sound.ENTITY_PLAYER_HURT_ON_FIRE, 1.0f, 1.0f);
                        for (int angle = 0; angle < 360; angle += 20) {
                            double rad = Math.toRadians(angle);
                            double offsetX = 5.0 * Math.cos(rad);
                            double offsetZ = 5.0 * Math.sin(rad);
                            Location particleLoc = center.clone().add(offsetX, 0.1, offsetZ);
                            world.spawnParticle(Particle.LAVA, particleLoc, 10, 0.05, 0.05, 0.05, 0.01);
                        }
                        for (Player target : world.getPlayers()) {
                            if (target.equals((Object)caster) || !(target.getLocation().distance(center) <= 5.0)) continue;
                            target.damage(8.0, (Entity)caster);
                        }
                    }
                    ++this.tick;
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void startDarkRedDustEffect(final Location startLoc, Player caster) {
        final World world = startLoc.getWorld();
        double explosionRadius = 5.0;
        for (Player target : world.getPlayers()) {
            if (target.equals((Object)caster) || !(target.getLocation().distance(startLoc) <= explosionRadius)) continue;
            target.setVelocity(new Vector(0.0, 2.0, 0.0));
        }
        world.playSound(startLoc, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
        new BukkitRunnable(this){
            int tick = 0;

            public void run() {
                if (this.tick >= 60) {
                    this.cancel();
                } else {
                    double baseRadius = 5.0;
                    double spreadFactor = (double)this.tick * 0.1;
                    double circleRadius = baseRadius + spreadFactor;
                    double particleHeightOffset = (double)this.tick * 3.0;
                    if (particleHeightOffset > 30.0) {
                        this.cancel();
                    } else {
                        for (int angle = 0; angle < 360; ++angle) {
                            double rad = Math.toRadians(angle);
                            double offsetX = circleRadius * Math.cos(rad);
                            double offsetZ = circleRadius * Math.sin(rad);
                            Location particleLoc = startLoc.clone().add(offsetX, particleHeightOffset, offsetZ);
                            world.spawnParticle(Particle.DUST_PILLAR, particleLoc, 3, 0.0, 0.0, 0.0, 0.0, (Object)Material.REDSTONE_BLOCK.createBlockData());
                        }
                        ++this.tick;
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }
}

