/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Effects;

import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.CooldownManager;
import com.catadmirer.infuseSMP.Managers.EffectManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class Thunder
implements Listener {
    private final Set<UUID> activeSparks = new HashSet<UUID>();
    private final Map<UUID, Long> entityLightningCooldowns = new HashMap<UUID, Long>();
    private EffectManager trustManager;
    private final Infuse plugin;

    public Thunder(Infuse plugin, EffectManager trustManager) {
        this.plugin = plugin;
        this.trustManager = trustManager;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public static ItemStack createTHUNDER() {
        ItemStack gem = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)gem.getItemMeta();
        if (meta != null) {
            String gemName = Infuse.getInstance().getEffect("thunder");
            meta.setDisplayName(gemName);
            meta.setColor(Color.fromRGB((int)255, (int)255, (int)0));
            List<String> lore = Infuse.getInstance().getEffectLore("thunder");
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(13));
            gem.setItemMeta((ItemMeta)meta);
        }
        return gem;
    }

    public static boolean isInvincibilityGem(ItemStack item) {
        if (item != null && item.getType() == Material.POTION && item.getItemMeta() != null) {
            return item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == 13;
        }
        return false;
    }

    private boolean hasImmortalHackEquipped(Player player) {
        String hack1 = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), "1");
        String hack2 = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), "2");
        String gemName = this.plugin.getEffect("thunder");
        String gemName2 = this.plugin.getEffect("aug_thunder");
        return hack1 != null && (hack1.equals(gemName) || hack2 != null && hack2.equals(gemName2));
    }

    @EventHandler
    public void onTridentHit(EntityDamageByEntityEvent event) {
        Trident trident;
        Entity var3 = event.getDamager();
        if (var3 instanceof Trident && !(trident = (Trident)var3).hasMetadata("thunderProcessed")) {
            Entity var5;
            Player attacker;
            trident.setMetadata("thunderProcessed", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            ProjectileSource var4 = trident.getShooter();
            if (var4 instanceof Player && this.hasImmortalHackEquipped(attacker = (Player)var4) && (var5 = event.getEntity()) instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)var5;
                target.getWorld().strikeLightningEffect(target.getLocation());
                target.damage(4.0, (Entity)attacker);
                target.getWorld().spawnParticle(Particle.DUST, target.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.0, (Object)new Particle.DustOptions(Color.YELLOW, 1.5f));
            }
        }
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        this.handleOffhand(event);
    }

    public void handleOffhand(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("ability.use")) {
            UUID playerUUID;
            boolean isCommon;
            boolean isLegendary = player.isSneaking() && this.hasThunderEquipped(player, "1");
            boolean bl = isCommon = !player.isSneaking() && this.hasThunderEquipped(player, "2");
            if ((isLegendary || isCommon) && !CooldownManager.isOnCooldown(playerUUID = player.getUniqueId(), "thunder")) {
                event.setCancelled(true);
                this.activateSpark(player);
            }
        }
    }

    private boolean hasThunderEquipped(Player player, String tier) {
        String currentHack = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), tier);
        String gemName = this.plugin.getEffect("thunder");
        String gemName2 = this.plugin.getEffect("aug_thunder");
        return currentHack != null && (currentHack.equals(gemName) || currentHack.equals(gemName2));
    }

    public void activateSpark(final Player caster) {
        final UUID playerUUID = caster.getUniqueId();
        if (!CooldownManager.isOnCooldown(playerUUID, "thunder") && !this.activeSparks.contains(playerUUID)) {
            this.activeSparks.add(playerUUID);
            caster.getWorld().playSound(caster.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
            String gemName2 = this.plugin.getEffect("aug_thunder");
            boolean isAugmented = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).equalsIgnoreCase(ChatColor.stripColor((String)ChatColor.stripColor((String)gemName2))) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).equalsIgnoreCase(ChatColor.stripColor((String)ChatColor.stripColor((String)gemName2)));
            long defaultCooldown = ((Integer)Infuse.getInstance().getCanfig("thunder.cooldown.default")).longValue();
            long augmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("thunder.cooldown.augmented")).longValue();
            long cooldown = isAugmented ? augmentedCooldown : defaultCooldown;
            long defaultDuration = ((Integer)Infuse.getInstance().getCanfig("thunder.duration.default")).longValue();
            long augmentedDuration = ((Integer)Infuse.getInstance().getCanfig("thunder.duration.augmented")).longValue();
            long duration = isAugmented ? augmentedDuration : defaultDuration;
            final int effectDuration = (int)(duration * 20L);
            CooldownManager.setDuration(playerUUID, "thunder", duration);
            CooldownManager.setCooldown(playerUUID, "thunder", cooldown);
            double radius = 10.0;
            final World world = caster.getWorld();
            new BukkitRunnable(){
                int ticksElapsed = 0;

                public void run() {
                    if (this.ticksElapsed >= effectDuration) {
                        Thunder.this.activeSparks.remove(playerUUID);
                        this.cancel();
                        return;
                    }
                    Location center = caster.getLocation();
                    for (Entity entity : world.getNearbyEntities(center, 10.0, 10.0, 10.0)) {
                        Player p;
                        LivingEntity target;
                        if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity).equals((Object)caster) || target instanceof Player && Thunder.this.isTeammate(p = (Player)target, caster)) continue;
                        target.getWorld().strikeLightningEffect(target.getLocation());
                        target.damage(4.0, (Entity)caster);
                        world.spawnParticle(Particle.DUST, target.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.0, (Object)new Particle.DustOptions(Color.YELLOW, 1.5f));
                    }
                    this.ticksElapsed += 20;
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        }
    }

    private boolean isTeammate(Player player, Player caster) {
        return this.trustManager.isTrusted(player, caster);
    }

    @EventHandler
    public void onPlayerAttack(EntityDamageByEntityEvent event) {
        Player attacker;
        if (event.getDamager() instanceof Player && this.hasImmortalHackEquipped(attacker = (Player)event.getDamager()) && event.getEntity() instanceof LivingEntity) {
            long lastStrikeTime;
            LivingEntity target = (LivingEntity)event.getEntity();
            UUID targetUUID = target.getUniqueId();
            long currentTime = System.currentTimeMillis();
            if (this.entityLightningCooldowns.containsKey(targetUUID) && currentTime - (lastStrikeTime = this.entityLightningCooldowns.get(targetUUID).longValue()) < 2000L) {
                return;
            }
            this.entityLightningCooldowns.put(targetUUID, currentTime);
            List nearbyEntities = target.getNearbyEntities(3.0, 3.0, 3.0);
            Optional<Entity> nextChainTarget = nearbyEntities.stream().filter(e -> e instanceof LivingEntity && !e.equals((Object)attacker)).findFirst();
            if (nextChainTarget.isPresent()) {
                target.getWorld().strikeLightningEffect(target.getLocation());
                target.damage(4.0, (Entity)attacker);
                target.getWorld().spawnParticle(Particle.DUST, target.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.0, (Object)new Particle.DustOptions(Color.YELLOW, 1.5f));
                this.chainLightning((Entity)target, attacker);
            }
        }
    }

    private void chainLightning(Entity startEntity, final Player attacker) {
        final HashSet processedEntities = new HashSet();
        final LinkedList<Entity> queue = new LinkedList<Entity>();
        queue.add(startEntity);
        new BukkitRunnable(this){
            int strikes = 0;

            public void run() {
                if (!queue.isEmpty() && this.strikes < 5) {
                    Entity currentEntity = null;
                    while (!queue.isEmpty()) {
                        Entity candidate = (Entity)queue.poll();
                        if (!(candidate instanceof LivingEntity) || processedEntities.contains(candidate)) continue;
                        currentEntity = candidate;
                        break;
                    }
                    if (currentEntity != null) {
                        processedEntities.add(currentEntity);
                        LivingEntity livingEntity = (LivingEntity)currentEntity;
                        if (!livingEntity.equals((Object)attacker)) {
                            livingEntity.getWorld().strikeLightningEffect(livingEntity.getLocation());
                            livingEntity.damage(4.0, (Entity)attacker);
                            livingEntity.getWorld().spawnParticle(Particle.DUST, livingEntity.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.0, (Object)new Particle.DustOptions(Color.YELLOW, 1.5f));
                            ++this.strikes;
                            for (Entity entity : livingEntity.getNearbyEntities(3.0, 3.0, 3.0)) {
                                if (!(entity instanceof LivingEntity) || processedEntities.contains(entity)) continue;
                                queue.add(entity);
                            }
                        }
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }
}

