/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Effects;

import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.CooldownManager;
import com.catadmirer.infuseSMP.Managers.EffectManager;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateHealth;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Invisibility
implements Listener,
PacketListener {
    private final Plugin plugin;
    private final EffectManager trustManager;
    private final Map<UUID, Integer> meleeHitCounter = new HashMap<UUID, Integer>();

    public Invisibility(Plugin plugin, EffectManager trustManager) {
        this.plugin = plugin;
        this.trustManager = trustManager;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, plugin);
        new BukkitRunnable(){

            public void run() {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!Invisibility.this.hasImmortalHackEquipped2(p, "1") && !Invisibility.this.hasImmortalHackEquipped2(p, "2")) continue;
                    p.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 40, 0, false, false));
                }
            }
        }.runTaskTimer(plugin, 0L, 20L);
    }

    public static ItemStack createStealthGem() {
        ItemStack gem = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)gem.getItemMeta();
        if (meta != null) {
            String gemName = Infuse.getInstance().getEffect("invis");
            meta.setDisplayName(gemName);
            List<String> lore = Infuse.getInstance().getEffectLore("invis");
            meta.setColor(Color.fromRGB((int)204, (int)51, (int)255));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(7));
            gem.setItemMeta((ItemMeta)meta);
        }
        return gem;
    }

    public static boolean isStealthGem(ItemStack item) {
        return item != null && item.getType() == Material.POTION && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == 7;
    }

    private void hideHealthForPlayer(final Player player, final int durationSeconds) {
        new BukkitRunnable(this){
            int elapsedTicks = 0;

            public void run() {
                WrapperPlayServerUpdateHealth packet = new WrapperPlayServerUpdateHealth(20.0f, 20, 5.0f);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)packet);
                this.elapsedTicks += 2;
                if (this.elapsedTicks >= durationSeconds * 20) {
                    this.cancel();
                }
            }
        }.runTaskTimer(this.plugin, 0L, 2L);
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Player shooter;
        if (event.getEntity().getShooter() instanceof Player && (this.hasImmortalHackEquipped2(shooter = (Player)event.getEntity().getShooter(), "1") || this.hasImmortalHackEquipped2(shooter, "2")) && event.getEntity() instanceof Arrow && event.getHitEntity() instanceof Player) {
            Player target = (Player)event.getHitEntity();
            target.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 80, 0, false, false));
            this.hideHealthForPlayer(target, 4);
            this.spawnBlackParticles(target, 4);
        }
    }

    @EventHandler
    public void onMeleeHit(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player && event.getEntity() instanceof Player) {
            Player attacker = (Player)event.getDamager();
            Player target = (Player)event.getEntity();
            if (this.hasImmortalHackEquipped2(attacker, "1") || this.hasImmortalHackEquipped2(attacker, "2")) {
                int count = this.meleeHitCounter.getOrDefault(attacker.getUniqueId(), 0) + 1;
                this.meleeHitCounter.put(attacker.getUniqueId(), count);
                if (count >= 20) {
                    target.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 80, 0, false, false));
                    this.hideHealthForPlayer(target, 4);
                    this.spawnBlackParticles(target, 4);
                    this.meleeHitCounter.put(attacker.getUniqueId(), 0);
                }
            }
        }
    }

    private void spawnBlackParticles(final Player target, final int durationInSeconds) {
        new BukkitRunnable(this){
            int ticksElapsed = 0;
            final int maxTicks = durationInSeconds * 20;

            public void run() {
                if (this.ticksElapsed >= this.maxTicks) {
                    this.cancel();
                } else {
                    target.getWorld().spawnParticle(Particle.SQUID_INK, target.getLocation().add(0.0, 1.0, 0.0), 3, 0.5, 0.5, 0.5, 0.0);
                    this.ticksElapsed += 5;
                }
            }
        }.runTaskTimer(this.plugin, 0L, 5L);
    }

    @EventHandler
    public void onEntityTarget(EntityTargetEvent event) {
        Player target;
        if (event.getTarget() instanceof Player && (this.hasImmortalHackEquipped2(target = (Player)event.getTarget(), "1") || this.hasImmortalHackEquipped2(target, "1"))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        this.handleOffhand(event);
    }

    public void handleOffhand(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("ability.use")) {
            UUID playerUUID;
            boolean isCommon;
            boolean isLegendary = player.isSneaking() && this.hasImmortalHackEquipped2(player, "1");
            boolean bl = isCommon = !player.isSneaking() && this.hasImmortalHackEquipped2(player, "2");
            if ((isLegendary || isCommon) && !CooldownManager.isOnCooldown(playerUUID = player.getUniqueId(), "invis")) {
                event.setCancelled(true);
                this.activateSpark(player);
            }
        }
    }

    private boolean hasImmortalHackEquipped2(Player player, String tier) {
        String currentHack = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), tier);
        String gemName2 = Infuse.getInstance().getEffect("aug_invis");
        String gemName = Infuse.getInstance().getEffect("invis");
        return currentHack != null && (currentHack.equals(gemName2) || currentHack.equals(gemName));
    }

    public void activateSpark(final Player caster) {
        UUID playerUUID = caster.getUniqueId();
        if (!CooldownManager.isOnCooldown(playerUUID, "invis")) {
            caster.playSound(caster.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
            String gemName2 = Infuse.getInstance().getEffect("aug_invis");
            boolean isAugmentedInvis = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).toLowerCase().equalsIgnoreCase(ChatColor.stripColor((String)gemName2));
            long invisDefaultCooldown = ((Integer)Infuse.getInstance().getCanfig("invisibility.cooldown.default")).longValue();
            long invisAugmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("invisibility.cooldown.augmented")).longValue();
            long invisCooldown = isAugmentedInvis ? invisAugmentedCooldown : invisDefaultCooldown;
            long invisDefaultDuration = ((Integer)Infuse.getInstance().getCanfig("invisibility.duration.default")).longValue();
            long invisAugmentedDuration = ((Integer)Infuse.getInstance().getCanfig("invisibility.duration.augmented")).longValue();
            long invisDuration = isAugmentedInvis ? invisAugmentedDuration : invisDefaultDuration;
            double radius = 10.0;
            final long durationTicks = invisDuration * 20L;
            final World world = caster.getWorld();
            final HashSet<Player> vanishedPlayers = new HashSet<Player>();
            for (Player vanished : Bukkit.getOnlinePlayers()) {
                if (!vanished.getWorld().equals((Object)world) || !(vanished.getLocation().distance(caster.getLocation()) <= 10.0) || !this.isTeammate(caster, vanished)) continue;
                vanishedPlayers.add(vanished);
            }
            for (Player vanished : vanishedPlayers) {
                for (Player other : Bukkit.getOnlinePlayers()) {
                    if (other.equals((Object)vanished) || this.isTeammate(other, vanished)) continue;
                    other.hidePlayer(this.plugin, vanished);
                }
            }
            new BukkitRunnable(){
                long ticksElapsed = 0L;

                public void run() {
                    if (this.ticksElapsed >= durationTicks) {
                        this.cancel();
                        for (Player vanished : vanishedPlayers) {
                            for (Player other : Bukkit.getOnlinePlayers()) {
                                other.showPlayer(Invisibility.this.plugin, vanished);
                            }
                        }
                    } else {
                        Location center = caster.getLocation();
                        for (int angle = 0; angle < 360; angle += 2) {
                            double rad = Math.toRadians(angle);
                            double baseX = center.getX() + 10.0 * Math.cos(rad);
                            double baseZ = center.getZ() + 10.0 * Math.sin(rad);
                            Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)0, (int)0, (int)0), 15.0f);
                            for (int i = 0; i < 1; ++i) {
                                double offsetX = (Math.random() - 0.5) * 0.3;
                                double offsetZ = (Math.random() - 0.5) * 0.3;
                                Location particleLoc = new Location(world, baseX + offsetX, center.getY(), baseZ + offsetZ);
                                world.spawnParticle(Particle.DUST, particleLoc, 1, (Object)dustOptions);
                            }
                        }
                        for (Player p : Bukkit.getOnlinePlayers()) {
                            if (!p.getWorld().equals((Object)world) || !(p.getLocation().distance(center) <= 10.0) || Invisibility.this.isTeammate(p, caster)) continue;
                            p.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0, false, false));
                            Invisibility.this.hideHealthForPlayer(p, 2);
                        }
                        this.ticksElapsed += 10L;
                    }
                }
            }.runTaskTimer(this.plugin, 0L, 10L);
            CooldownManager.setDuration(playerUUID, "invis", invisDuration);
            CooldownManager.setCooldown(playerUUID, "invis", invisCooldown);
        }
    }

    private boolean isTeammate(Player player, Player caster) {
        return this.trustManager.isTrusted(player, caster);
    }
}

