/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Effects;

import com.catadmirer.infuseSMP.Infuse;
import com.catadmirer.infuseSMP.Managers.CooldownManager;
import com.catadmirer.infuseSMP.Managers.EffectManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Ender
implements Listener {
    private final Infuse plugin;
    private final HashMap<UUID, Integer> dragonBreathCooldowns = new HashMap();
    private final Set<UUID> cursedPlayers = new HashSet<UUID>();
    private final Set<UUID> processingDamage = new HashSet<UUID>();
    private EffectManager trustManager;
    private final Set<UUID> curseChain = new HashSet<UUID>();

    public Ender(EffectManager trustManager, Infuse plugin) {
        this.trustManager = trustManager;
        this.plugin = plugin;
        new BukkitRunnable(){

            public void run() {
                Ender.this.dragonBreathCooldowns.replaceAll((uuid, time) -> time > 0 ? time - 1 : 0);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    boolean isLegendary = Ender.this.hasImmortalHackEquipped2(player, "1");
                    boolean isCommon = Ender.this.hasImmortalHackEquipped2(player, "2");
                    if (isLegendary || isCommon) {
                        Ender.this.applyGlowingToUntrusted(player);
                    }
                    if (!Ender.this.cursedPlayers.contains(player.getUniqueId())) continue;
                    player.getWorld().spawnParticle(Particle.WITCH, player.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.5, 0.3, 0.01);
                }
            }
        }.runTaskTimer((Plugin)plugin, 0L, 20L);
    }

    public static boolean ISENDER(ItemStack item) {
        String gemName = Infuse.getInstance().getEffect("ender");
        return item != null && item.getType() == Material.POTION && item.getItemMeta().getDisplayName().equals(gemName);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        final Player damagedPlayer = (Player)entity;
        final UUID damagedUUID = damagedPlayer.getUniqueId();
        if (!this.cursedPlayers.contains(damagedUUID)) {
            return;
        }
        if (this.processingDamage.contains(damagedUUID) || this.curseChain.contains(damagedUUID)) {
            return;
        }
        final double damage = event.getDamage();
        this.processingDamage.add(damagedUUID);
        new BukkitRunnable(){

            public void run() {
                try {
                    Ender.this.curseChain.add(damagedUUID);
                    for (final UUID cursedUUID : new HashSet<UUID>(Ender.this.cursedPlayers)) {
                        Player cursed;
                        if (cursedUUID.equals(damagedUUID) || Ender.this.processingDamage.contains(cursedUUID) || Ender.this.curseChain.contains(cursedUUID) || (cursed = Bukkit.getPlayer((UUID)cursedUUID)) == null || !cursed.isOnline() || cursed.isDead()) continue;
                        Ender.this.processingDamage.add(cursedUUID);
                        Ender.this.curseChain.add(cursedUUID);
                        cursed.damage(damage, (Entity)damagedPlayer);
                        new BukkitRunnable(){

                            public void run() {
                                Ender.this.processingDamage.remove(cursedUUID);
                                Ender.this.curseChain.remove(cursedUUID);
                            }
                        }.runTaskLater((Plugin)Ender.this.plugin, 5L);
                    }
                    new BukkitRunnable(){

                        public void run() {
                            Ender.this.processingDamage.remove(damagedUUID);
                            Ender.this.curseChain.remove(damagedUUID);
                        }
                    }.runTaskLater((Plugin)Ender.this.plugin, 5L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Ender.this.processingDamage.remove(damagedUUID);
                    Ender.this.curseChain.remove(damagedUUID);
                }
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        this.handleOffhand(event);
    }

    public void handleOffhand(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("ability.use")) {
            boolean isLegendary = this.hasImmortalHackEquipped2(player, "1");
            boolean isCommon = this.hasImmortalHackEquipped2(player, "2");
            UUID playerUUID = player.getUniqueId();
            if (!CooldownManager.isOnCooldown(playerUUID, "ender") && (player.isSneaking() && isLegendary || !player.isSneaking() && isCommon)) {
                event.setCancelled(true);
                this.activateSpark(player);
            }
        }
    }

    private boolean isTeammate(Player player, Player caster) {
        return this.trustManager.isTrusted(player, caster);
    }

    public void activateSpark(Player player) {
        Location checkLoc;
        UUID playerUUID = player.getUniqueId();
        if (CooldownManager.isOnCooldown(playerUUID, "ender")) {
            return;
        }
        String gemName = Infuse.getInstance().getEffect("aug_ender");
        boolean isAugEnder = Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "1")).equalsIgnoreCase(ChatColor.stripColor((String)gemName)) || Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2") != null && ChatColor.stripColor((String)Infuse.getInstance().getEffectManager().getEffect(playerUUID, "2")).equalsIgnoreCase(ChatColor.stripColor((String)gemName));
        long featherDefaultCooldown = ((Integer)Infuse.getInstance().getCanfig("feather.cooldown.default")).longValue();
        long featherAugmentedCooldown = ((Integer)Infuse.getInstance().getCanfig("feather.cooldown.augmented")).longValue();
        long endCooldown = isAugEnder ? featherAugmentedCooldown : featherDefaultCooldown;
        long featherDefaultDuration = ((Integer)Infuse.getInstance().getCanfig("feather.duration.default")).longValue();
        long featherAugmentedDuration = ((Integer)Infuse.getInstance().getCanfig("feather.duration.augmented")).longValue();
        long endDuration = isAugEnder ? featherAugmentedDuration : featherDefaultDuration;
        CooldownManager.setDuration(playerUUID, "ender", endDuration);
        CooldownManager.setCooldown(playerUUID, "ender", endCooldown);
        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
        Location startLoc = player.getEyeLocation();
        Vector direction = startLoc.getDirection().normalize();
        int maxDistance = 15;
        Location targetLoc = null;
        for (int i = 1; i <= maxDistance && this.isSafeTeleportLocation(checkLoc = startLoc.clone().add(direction.clone().multiply(i))); ++i) {
            targetLoc = checkLoc;
        }
        if (targetLoc != null) {
            Location finalLoc = targetLoc.clone();
            finalLoc.setYaw(player.getLocation().getYaw());
            finalLoc.setPitch(player.getLocation().getPitch());
            player.teleport(finalLoc);
        }
    }

    private boolean isSafeTeleportLocation(Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            return false;
        }
        Location feet = loc.clone();
        Location head = loc.clone().add(0.0, 1.0, 0.0);
        return !feet.getBlock().getType().isSolid() && !head.getBlock().getType().isSolid();
    }

    @EventHandler
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        UUID attackerUUID = attacker.getUniqueId();
        long sparkActive1 = CooldownManager.getEffectTimeLeft(attackerUUID, "ender");
        long sparkActive2 = CooldownManager.getEffectTimeLeft(attackerUUID, "aug_ender");
        long sparkActive = Math.max(sparkActive1, sparkActive2);
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity mob = (LivingEntity)entity2;
            if (!(event.getEntity() instanceof Player) && sparkActive > 0L) {
                mob.setHealth(0.0);
            }
        }
    }

    private boolean hasImmortalHackEquipped2(Player player, String tier) {
        String currentHack = Infuse.getInstance().getEffectManager().getEffect(player.getUniqueId(), tier);
        String gemName = Infuse.getInstance().getEffect("ender");
        String gemName2 = Infuse.getInstance().getEffect("aug_ender");
        return currentHack != null && (currentHack.equals(gemName) || currentHack.equals(gemName2));
    }

    public static ItemStack createEnderGem() {
        ItemStack gem = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)gem.getItemMeta();
        if (meta != null) {
            String gemName = Infuse.getInstance().getEffect("ender");
            meta.setDisplayName(gemName);
            List<String> lore = Infuse.getInstance().getEffectLore("ender");
            meta.setColor(Color.fromRGB((int)135, (int)18, (int)119));
            meta.setLore(lore);
            meta.setCustomModelData(Integer.valueOf(25));
            gem.setItemMeta((ItemMeta)meta);
        }
        return gem;
    }

    @EventHandler
    public void onUseDragonBreath(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        boolean isLegendary = this.hasImmortalHackEquipped2(player, "1");
        boolean isCommon = this.hasImmortalHackEquipped2(player, "2");
        if (isLegendary || isCommon) {
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item.getType() != Material.DRAGON_BREATH) {
                return;
            }
            this.shootCursingFireball(player);
            event.setCancelled(true);
        }
    }

    public void shootCursingFireball(Player player) {
        UUID uuid = player.getUniqueId();
        int cooldown = this.dragonBreathCooldowns.getOrDefault(uuid, 0);
        if (cooldown > 0) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait " + cooldown + " seconds before using Dragon's Breath again!");
            return;
        }
        ItemStack handItem = player.getInventory().getItemInMainHand();
        if (handItem.getAmount() > 1) {
            handItem.setAmount(handItem.getAmount() - 1);
        } else {
            player.getInventory().setItemInMainHand(null);
        }
        Fireball fireball = (Fireball)player.launchProjectile(Fireball.class);
        fireball.setIsIncendiary(false);
        fireball.setYield(4.0f);
        fireball.setCustomName("Cursing Projectile");
        this.dragonBreathCooldowns.put(uuid, 30);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You shot a cursing fireball! Cooldown started.");
    }

    @EventHandler
    public void onFireballDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Fireball)) {
            return;
        }
        Fireball fireball = (Fireball)entity;
        if (!"Cursing Projectile".equals(fireball.getCustomName())) {
            return;
        }
        event.setDamage(0.0);
    }

    @EventHandler
    public void onFireballHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof Fireball)) {
            return;
        }
        Fireball fireball = (Fireball)projectile;
        if (!"Cursing Projectile".equals(fireball.getCustomName())) {
            return;
        }
        Entity entity = event.getHitEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player target = (Player)entity;
        Player shooter = (Player)fireball.getShooter();
        if (shooter == null) {
            return;
        }
        if (this.isTeammate(target, shooter)) {
            return;
        }
        this.cursedPlayers.add(target.getUniqueId());
        target.sendMessage(String.valueOf(ChatColor.RED) + "You have been cursed!");
        this.removeCurseLater(target.getUniqueId(), 1200L);
    }

    public void removeCurseLater(final UUID playerUUID, long delayTicks) {
        new BukkitRunnable(){

            public void run() {
                Ender.this.cursedPlayers.remove(playerUUID);
                Player player = Bukkit.getPlayer((UUID)playerUUID);
                if (player != null && player.isOnline()) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "The curse has worn off.");
                }
            }
        }.runTaskLater((Plugin)this.plugin, delayTicks);
    }

    public void applyGlowingToUntrusted(Player player) {
        boolean isLegendary = this.hasImmortalHackEquipped2(player, "1");
        boolean isCommon = this.hasImmortalHackEquipped2(player, "2");
        double radius = 10.0;
        Collection nearbyEntities = player.getWorld().getNearbyEntities(player.getLocation(), radius, radius, radius);
        for (Entity entity : nearbyEntities) {
            Player nearby;
            if (!(entity instanceof Player) || (nearby = (Player)entity).getUniqueId().equals(player.getUniqueId()) || this.trustManager.isTrusted(nearby, player) || !isLegendary && !isCommon || nearby.hasPotionEffect(PotionEffectType.GLOWING)) continue;
            nearby.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 40, 1, false, false));
        }
    }
}

