/*
 * Decompiled with CFR 0.152.
 */
package com.catadmirer.infuseSMP.Commands;

import com.catadmirer.infuseSMP.Effects.Augmented;
import com.catadmirer.infuseSMP.Effects.Emerald;
import com.catadmirer.infuseSMP.Effects.Ender;
import com.catadmirer.infuseSMP.Effects.Feather;
import com.catadmirer.infuseSMP.Effects.Fire;
import com.catadmirer.infuseSMP.Effects.Frost;
import com.catadmirer.infuseSMP.Effects.Haste;
import com.catadmirer.infuseSMP.Effects.Heart;
import com.catadmirer.infuseSMP.Effects.Invisibility;
import com.catadmirer.infuseSMP.Effects.Ocean;
import com.catadmirer.infuseSMP.Effects.Regen;
import com.catadmirer.infuseSMP.Effects.Speed;
import com.catadmirer.infuseSMP.Effects.Strength;
import com.catadmirer.infuseSMP.Effects.Thunder;
import com.catadmirer.infuseSMP.ExtraEffects.Apophis;
import com.catadmirer.infuseSMP.ExtraEffects.Thief;
import com.catadmirer.infuseSMP.Infuse;
import java.util.Map;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUI
implements Listener,
CommandExecutor {
    private final Infuse plugin;

    public GUI(Infuse plugin) {
        this.plugin = plugin;
    }

    public static void openSwordSelectionGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)"\u00a7lInfuses");
        ItemStack magenta = GUI.createPane(Material.MAGENTA_STAINED_GLASS_PANE);
        ItemStack purple = GUI.createPane(Material.PURPLE_STAINED_GLASS_PANE);
        ItemStack blue = GUI.createPane(Material.BLUE_STAINED_GLASS_PANE);
        ItemStack lightBlue = GUI.createPane(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        int[] magentaSlots = new int[]{0, 1, 2, 6, 7, 8, 9, 10, 16, 17, 18, 26, 27, 35};
        int[] purpleSlots = new int[]{36, 37, 43, 44, 45, 46, 47, 48, 50, 51, 52, 53};
        int[] blueSlots = new int[]{49};
        int[] lightBlueSlots = new int[]{3, 4, 5, 11, 13, 15, 19, 25, 28, 34, 38, 42};
        GUI.setItems(gui, magentaSlots, magenta);
        GUI.setItems(gui, purpleSlots, purple);
        GUI.setItems(gui, blueSlots, blue);
        GUI.setItems(gui, lightBlueSlots, lightBlue);
        Augmented augmented = new Augmented(Infuse.getInstance());
        Map.Entry[] entryArray = new Map.Entry[13];
        entryArray[0] = Map.entry(12, Augmented.createFROST());
        entryArray[1] = Map.entry(14, augmented.createSPEED());
        entryArray[2] = Map.entry(20, Augmented.createFEATHER());
        entryArray[3] = Map.entry(21, Augmented.createOCEAN());
        entryArray[4] = Map.entry(22, Augmented.createINVIS());
        entryArray[5] = Map.entry(23, Augmented.createENDER());
        entryArray[6] = Map.entry(24, Augmented.createEME());
        entryArray[7] = Map.entry(29, Augmented.createHEART());
        entryArray[8] = Map.entry(30, Augmented.createREGEN());
        entryArray[9] = Map.entry(31, augmented.createST());
        entryArray[10] = Map.entry(32, Augmented.createFIRE());
        entryArray[11] = Map.entry(33, Augmented.createHASTE());
        entryArray[12] = Map.entry(40, augmented.createTHUNDER());
        Map<Integer, ItemStack> infusedItems = Map.ofEntries(entryArray);
        infusedItems.forEach((arg_0, arg_1) -> ((Inventory)gui).setItem(arg_0, arg_1));
        if (((Boolean)Infuse.getInstance().getCanfig("extra_effects.Thief")).booleanValue()) {
            gui.setItem(39, Augmented.createTHF());
        }
        if (((Boolean)Infuse.getInstance().getCanfig("extra_effects.Apophis")).booleanValue()) {
            gui.setItem(41, Augmented.createAPH());
        }
        player.openInventory(gui);
    }

    private static ItemStack createPane(Material material) {
        ItemStack pane = new ItemStack(material);
        ItemMeta meta = pane.getItemMeta();
        meta.setDisplayName(" ");
        pane.setItemMeta(meta);
        return pane;
    }

    private static void setItems(Inventory gui, int[] slots, ItemStack item) {
        for (int slot : slots) {
            gui.setItem(slot, item);
        }
    }

    private void openDaGui(Player player, Supplier<ItemStack> augmentedSupplier, Supplier<ItemStack> regularSupplier, Material backgroundColor) {
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)"\u00a7eChoose");
        this.fillChoiceGUI(gui, backgroundColor);
        gui.setItem(11, regularSupplier.get());
        gui.setItem(15, augmentedSupplier.get());
        player.openInventory(gui);
    }

    private void fillChoiceGUI(Inventory gui, Material color) {
        ItemStack filler = new ItemStack(color);
        ItemMeta meta = filler.getItemMeta();
        meta.setDisplayName(" ");
        filler.setItemMeta(meta);
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.setItem(i, filler);
        }
    }

    @EventHandler
    public void onClicky(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null) {
            return;
        }
        String title = event.getView().getTitle();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        Augmented augmented = new Augmented(Infuse.getInstance());
        if (title.equals("\u00a7lInfuses")) {
            event.setCancelled(true);
            if (Augmented.ISFROST(clicked)) {
                this.openDaGui(player, Augmented::createFROST, Frost::createFrost, Material.LIGHT_BLUE_STAINED_GLASS_PANE);
            } else if (augmented.ISSPEED(clicked)) {
                this.openDaGui(player, Augmented::createSPEED, Speed::createSPEED, Material.LIGHT_BLUE_STAINED_GLASS_PANE);
            } else if (augmented.ISST(clicked)) {
                this.openDaGui(player, Augmented::createST, Strength::createStealthGem, Material.RED_STAINED_GLASS_PANE);
            } else if (augmented.ISTHUNDER(clicked)) {
                this.openDaGui(player, Augmented::createTHUNDER, Thunder::createTHUNDER, Material.YELLOW_STAINED_GLASS_PANE);
            } else if (Augmented.ISTHIEF(clicked)) {
                this.openDaGui(player, Augmented::createTHF, Thief::createTHF, Material.RED_STAINED_GLASS_PANE);
            } else if (Augmented.ISHEART(clicked)) {
                this.openDaGui(player, Augmented::createHEART, Heart::createHeart, Material.RED_STAINED_GLASS_PANE);
            } else if (Augmented.ISEME(clicked)) {
                this.openDaGui(player, Augmented::createEME, Emerald::createInvincibilityGem, Material.LIME_STAINED_GLASS_PANE);
            } else if (Augmented.ISEND(clicked)) {
                this.openDaGui(player, Augmented::createENDER, Ender::createEnderGem, Material.PURPLE_STAINED_GLASS_PANE);
            } else if (Augmented.ISAUGAPH(clicked)) {
                this.openDaGui(player, Augmented::createAPH, Apophis::createAPH, Material.MAGENTA_STAINED_GLASS_PANE);
            } else if (Augmented.ISFEATHER(clicked)) {
                this.openDaGui(player, Augmented::createFEATHER, Feather::createGlide, Material.WHITE_STAINED_GLASS_PANE);
            } else if (Augmented.ISFIRE(clicked)) {
                this.openDaGui(player, Augmented::createFIRE, Fire::createFIRE, Material.ORANGE_STAINED_GLASS_PANE);
            } else if (Augmented.ISHASTE(clicked)) {
                this.openDaGui(player, Augmented::createHASTE, Haste::createFake, Material.ORANGE_STAINED_GLASS_PANE);
            } else if (Augmented.ISINVIS(clicked)) {
                this.openDaGui(player, Augmented::createINVIS, Invisibility::createStealthGem, Material.LIGHT_GRAY_STAINED_GLASS_PANE);
            } else if (Augmented.ISOCEAN(clicked)) {
                this.openDaGui(player, Augmented::createOCEAN, Ocean::createOcean, Material.BLUE_STAINED_GLASS_PANE);
            } else if (Augmented.ISREGEN(clicked)) {
                this.openDaGui(player, Augmented::createREGEN, Regen::createFake, Material.RED_STAINED_GLASS_PANE);
            }
            return;
        }
        if (title.equals("\u00a7eChoose") && clicked.getType() != Material.POTION) {
            event.setCancelled(true);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("infuses")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                GUI.openSwordSelectionGUI(player);
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            }
            return true;
        }
        return false;
    }
}

